/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.datagenerator;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import mda.ngchm.datagenerator.AttributeData;
import mda.ngchm.datagenerator.ColorMap;
import mda.ngchm.datagenerator.ImportConstants;
import mda.ngchm.datagenerator.ImportData;
import mda.ngchm.datagenerator.ImportLayerData;
import mda.ngchm.datagenerator.ImportTileData;
import mda.ngchm.datagenerator.InputFile;

public class HeatmapDataGenerator {
    public static void main(String[] args) {
        System.out.println("START: " + new Date());
        ImportData iData = new ImportData(args);
        int summaryInterval = 0;
        int i = 0;
        while (i < iData.importLayers.size()) {
            ImportLayerData ilData = iData.importLayers.get(i);
            if (ilData.layer.equals(ImportConstants.LAYER_SUMMARY)) {
                summaryInterval = ilData.rowInterval;
            }
            int j = 0;
            while (j < ilData.importTiles.size()) {
                ImportTileData itData = ilData.importTiles.get(j);
                HeatmapDataGenerator.writeTileFile(iData, ilData, itData);
                ++j;
            }
            ++i;
        }
        HeatmapDataGenerator.writeTileStructFile(iData);
        HeatmapDataGenerator.writeLabelsFiles(String.valueOf(iData.outputDir) + File.separator + ImportConstants.ROW_LABELS_FILE, iData, true);
        HeatmapDataGenerator.writeLabelsFiles(String.valueOf(iData.outputDir) + File.separator + ImportConstants.COL_LABELS_FILE, iData, false);
        HeatmapDataGenerator.writeDendrogramFile(iData, summaryInterval);
        HeatmapDataGenerator.writeClassificationsFile(iData, summaryInterval);
        HeatmapDataGenerator.writeColorMapFile(iData);
        HeatmapDataGenerator.writeChmFile(iData);
        if (ImportConstants.DEBUG) {
            HeatmapDataGenerator.writeClusteredDebugFile(iData);
        }
        System.out.println("END: " + new Date());
    }

    private static void writeTileFile(ImportData iData, ImportLayerData ilData, ImportTileData itData) {
        int writes = 0;
        try {
            File dataDir = new File(String.valueOf(iData.outputDir) + File.separator + ilData.layer);
            if (!dataDir.exists()) {
                dataDir.mkdirs();
            }
            DataOutputStream write = new DataOutputStream(new FileOutputStream(String.valueOf(iData.outputDir) + File.separator + itData.fileName));
            int rowStart = itData.rowStartPos;
            int rowEnd = itData.rowEndPos;
            int colStart = itData.colStartPos;
            int colEnd = itData.colEndPos;
            int rowInterval = ilData.rowInterval;
            int colInterval = ilData.colInterval;
            int nextColWrite = 0;
            int nextRowWrite = HeatmapDataGenerator.getNextRowWrite(ilData, rowStart);
            int nextCol = HeatmapDataGenerator.getNextColWrite(ilData, colStart);
            FilterOutputStream writeRow = null;
            if (ImportConstants.DEBUG) {
                writeRow = new DataOutputStream(new FileOutputStream(String.valueOf(iData.outputDir) + File.separator + itData.fileName + ImportConstants.TXT_FILE));
            }
            int row = rowStart;
            while (row < rowEnd) {
                if (row == nextRowWrite) {
                    nextColWrite = nextCol;
                    String valprint = null;
                    if (ImportConstants.DEBUG) {
                        valprint = Integer.toString(row);
                    }
                    int col = colStart;
                    while (col < colEnd) {
                        if (col == nextColWrite) {
                            float v = HeatmapDataGenerator.getMatrixValue(iData, ilData, row, col);
                            byte[] f = ByteBuffer.allocate(4).putFloat(v).array();
                            if (ImportConstants.DEBUG) {
                                valprint = String.valueOf(valprint) + ImportConstants.TAB + v;
                            }
                            write.write(f, 3, 1);
                            write.write(f, 2, 1);
                            write.write(f, 1, 1);
                            write.write(f, 0, 1);
                            ++writes;
                            nextColWrite += colInterval;
                        }
                        ++col;
                    }
                    if (ImportConstants.DEBUG) {
                        valprint = String.valueOf(valprint) + "\r\n";
                        ((DataOutputStream)writeRow).writeChars(valprint);
                    }
                    nextRowWrite += rowInterval;
                }
                ++row;
            }
            if (ImportConstants.DEBUG) {
                writeRow.close();
            }
            write.close();
            System.out.println("     File " + itData.fileName + " writes: " + writes);
        }
        catch (NumberFormatException ex) {
            System.out.println("ERROR: Non-numeric data found in matrix" + ex.toString());
            return;
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }

    private static float getMatrixValue(ImportData iData, ImportLayerData ilData, int row, int col) throws NumberFormatException {
        float value = 0.0f;
        try {
            if (iData.summaryMethod.equals(ImportConstants.METHOD_SAMPLE)) {
                value = Float.parseFloat(iData.reorgMatrix[row][col]);
            } else {
                int rowInter = ilData.rowInterval;
                int colInter = ilData.colInterval;
                if (rowInter + colInter == 2) {
                    value = Float.parseFloat(iData.reorgMatrix[row][col]);
                } else {
                    int rowBoundary = row + ilData.rowInterval;
                    int colBoundary = col + ilData.colInterval;
                    if (rowBoundary >= iData.reorgMatrix.length) {
                        rowBoundary = iData.reorgMatrix.length;
                        rowInter = rowBoundary - row;
                    }
                    if (colBoundary >= iData.reorgMatrix[0].length) {
                        colBoundary = iData.reorgMatrix[0].length;
                        colInter = colBoundary - col;
                    }
                    int combInter = rowInter * colInter;
                    float[] valArr = new float[combInter];
                    int valArrIdx = 0;
                    int i = row;
                    while (i < rowBoundary) {
                        int j = col;
                        while (j < colBoundary) {
                            if (HeatmapDataGenerator.isNumeric(iData.reorgMatrix[i][j])) {
                                valArr[valArrIdx] = Float.parseFloat(iData.reorgMatrix[i][j]);
                                ++valArrIdx;
                            } else {
                                throw new NumberFormatException();
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (iData.summaryMethod.equals(ImportConstants.METHOD_AVERAGE)) {
                        value = HeatmapDataGenerator.getAverageValue(valArr, combInter);
                    } else if (iData.summaryMethod.equals(ImportConstants.METHOD_MODE)) {
                        value = HeatmapDataGenerator.getPredominantValue(valArr);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
        return value;
    }

    private static float getAverageValue(float[] array, int combInter) {
        float value = 0.0f;
        int k = 0;
        while (k < array.length) {
            value += array[k];
            ++k;
        }
        return value / (float)combInter;
    }

    private static float getPredominantValue(float[] array) {
        int v;
        float value = 0.0f;
        ArrayList<Float> distinctVals = new ArrayList<Float>();
        int i = 0;
        while (i < array.length) {
            boolean found = false;
            float iVal = array[i];
            v = 0;
            while (v < distinctVals.size()) {
                if (((Float)distinctVals.get(v)).floatValue() == iVal) {
                    found = true;
                    break;
                }
                ++v;
            }
            if (!found) {
                distinctVals.add(Float.valueOf(iVal));
            }
            ++i;
        }
        int[] arrayIndex = new int[distinctVals.size()];
        int i2 = 0;
        while (i2 < distinctVals.size()) {
            int count = 0;
            v = 0;
            while (v < array.length) {
                if (array[v] == ((Float)distinctVals.get(i2)).floatValue()) {
                    ++count;
                }
                ++v;
            }
            arrayIndex[i2] = count;
            ++i2;
        }
        int highOcc = 0;
        int highIdx = 0;
        int i3 = 0;
        while (i3 < arrayIndex.length) {
            int occ = arrayIndex[i3];
            if (occ > highOcc) {
                highOcc = occ;
                highIdx = i3;
            }
            ++i3;
        }
        value = ((Float)distinctVals.get(highIdx)).floatValue();
        return value;
    }

    public static boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static int getNextRowWrite(ImportLayerData ilData, int rowStart) {
        int nextRowWrite = rowStart;
        if (Arrays.asList(ImportConstants.LAYER_THUMBNAIL, ImportConstants.LAYER_SUMMARY, ImportConstants.LAYER_RIBBONHORIZ).contains(ilData.layer) && rowStart != 1 && ilData.rowInterval != 1) {
            nextRowWrite = rowStart / ilData.rowInterval * ilData.rowInterval + 1;
        }
        return nextRowWrite;
    }

    private static int getNextColWrite(ImportLayerData ilData, int colStart) {
        int nextColWrite = colStart;
        if (Arrays.asList(ImportConstants.LAYER_THUMBNAIL, ImportConstants.LAYER_SUMMARY, ImportConstants.LAYER_RIBBONVERT).contains(ilData.layer) && colStart != 1 && ilData.colInterval != 1) {
            nextColWrite = colStart / ilData.colInterval * ilData.colInterval + 1;
        }
        return nextColWrite;
    }

    private static void writeTileStructFile(ImportData iData) {
        FilterOutputStream writeRow = null;
        OutputStreamWriter w = null;
        try {
            try {
                writeRow = new DataOutputStream(new FileOutputStream(String.valueOf(iData.outputDir) + File.separator + ImportConstants.TILE_STRUCT_FILE));
                w = new OutputStreamWriter((OutputStream)writeRow, ImportConstants.UTF8);
                w.write(String.valueOf(ImportConstants.BRACE_OPEN) + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.LEVELS_LABEL);
                w.write(String.valueOf(ImportConstants.LINE_FEED) + ImportConstants.TAB + ImportConstants.BRACE_OPEN);
                int i = 0;
                while (i < iData.importLayers.size()) {
                    ImportLayerData ilData = iData.importLayers.get(i);
                    w.write(String.valueOf(ImportConstants.LINE_FEED) + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.QUOTE + ilData.layer + ImportConstants.QUOTE + ImportConstants.COLON);
                    w.write(String.valueOf(ImportConstants.LINE_FEED) + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.BRACE_OPEN);
                    w.write(String.valueOf(ImportConstants.LINE_FEED) + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TILEROWS_LABEL + ilData.rowTiles);
                    w.write(String.valueOf(ImportConstants.COMMA) + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TILECOLS_LABEL + ilData.colTiles);
                    w.write(String.valueOf(ImportConstants.COMMA) + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TILEROWSPER_LABEL + ilData.rowsPerTile);
                    w.write(String.valueOf(ImportConstants.COMMA) + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TILECOLSPER_LABEL + ilData.colsPerTile);
                    w.write(String.valueOf(ImportConstants.COMMA) + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TOTALROWS_LABEL + ilData.totalLevelRows);
                    w.write(String.valueOf(ImportConstants.COMMA) + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TOTALCOLS_LABEL + ilData.totalLevelCols);
                    w.write(String.valueOf(ImportConstants.COMMA) + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.ROW_SUMMARY_RATIO_LABEL + ilData.rowInterval);
                    w.write(String.valueOf(ImportConstants.COMMA) + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.COL_SUMMARY_RATIO_LABEL + ilData.colInterval);
                    w.write(String.valueOf(ImportConstants.LINE_FEED) + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.BRACE_CLOSE);
                    if (i < iData.importLayers.size() - 1) {
                        w.write(ImportConstants.COMMA);
                    }
                    ++i;
                }
                w.write(String.valueOf(ImportConstants.LINE_FEED) + ImportConstants.TAB + ImportConstants.BRACE_CLOSE + ImportConstants.LINE_FEED + ImportConstants.BRACE_CLOSE);
                w.close();
                writeRow.close();
            }
            catch (Exception ex) {
                System.out.println("Exception: " + ex.toString());
                try {
                    w.close();
                    writeRow.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                w.close();
                writeRow.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void writeLabelsFiles(String fileName, ImportData iData, boolean isRowFile) {
        FilterOutputStream writeRow = null;
        OutputStreamWriter w = null;
        try {
            try {
                writeRow = new DataOutputStream(new FileOutputStream(fileName));
                w = new OutputStreamWriter((OutputStream)writeRow, ImportConstants.UTF8);
                w.write(ImportConstants.BRACE_OPEN);
                if (isRowFile) {
                    String rowOrderMethod = iData.rowData.orderMethod;
                    w.write(String.valueOf(ImportConstants.ORDER_METHOD_LABEL) + ImportConstants.QUOTE + rowOrderMethod + ImportConstants.QUOTE + ImportConstants.COMMA);
                    if (ImportConstants.ORDER_HIERARCHICAL.equals(rowOrderMethod)) {
                        w.write(String.valueOf(ImportConstants.AGGLOMERATION_LABEL) + ImportConstants.QUOTE + iData.rowData.agglomerationMethod + ImportConstants.QUOTE + ImportConstants.COMMA);
                        w.write(String.valueOf(ImportConstants.DISTANCE_METRIC_LABEL) + ImportConstants.QUOTE + iData.rowData.distanceMetric + ImportConstants.QUOTE + ImportConstants.COMMA);
                    } else {
                        w.write(String.valueOf(ImportConstants.AGGLOMERATION_LABEL) + ImportConstants.QUOTE + ImportConstants.NONE + ImportConstants.QUOTE + ImportConstants.COMMA);
                        w.write(String.valueOf(ImportConstants.DISTANCE_METRIC_LABEL) + ImportConstants.QUOTE + ImportConstants.NONE + ImportConstants.QUOTE + ImportConstants.COMMA);
                    }
                    w.write(String.valueOf(ImportConstants.LABEL_TYPE_LABEL) + ImportConstants.QUOTE + iData.matrixFiles.get((int)0).row_datatype + ImportConstants.QUOTE + ImportConstants.COMMA);
                    w.write(ImportConstants.LABELS_LABEL);
                    w.write(ImportConstants.BRACKET_OPEN);
                    int row = 1;
                    while (row < iData.importRows + 1) {
                        w.write(String.valueOf(ImportConstants.QUOTE) + iData.reorgMatrix[row][0] + ImportConstants.QUOTE);
                        if (row < iData.importRows) {
                            w.write(ImportConstants.COMMA);
                        }
                        ++row;
                    }
                } else {
                    String cowOrderMethod = iData.colData.orderMethod;
                    w.write(String.valueOf(ImportConstants.ORDER_METHOD_LABEL) + ImportConstants.QUOTE + cowOrderMethod + ImportConstants.QUOTE + ImportConstants.COMMA);
                    if (ImportConstants.ORDER_HIERARCHICAL.equals(cowOrderMethod)) {
                        w.write(String.valueOf(ImportConstants.AGGLOMERATION_LABEL) + ImportConstants.QUOTE + iData.colData.agglomerationMethod + ImportConstants.QUOTE + ImportConstants.COMMA);
                        w.write(String.valueOf(ImportConstants.DISTANCE_METRIC_LABEL) + ImportConstants.QUOTE + iData.colData.distanceMetric + ImportConstants.QUOTE + ImportConstants.COMMA);
                    } else {
                        w.write(String.valueOf(ImportConstants.AGGLOMERATION_LABEL) + ImportConstants.QUOTE + ImportConstants.NONE + ImportConstants.QUOTE + ImportConstants.COMMA);
                        w.write(String.valueOf(ImportConstants.DISTANCE_METRIC_LABEL) + ImportConstants.QUOTE + ImportConstants.NONE + ImportConstants.QUOTE + ImportConstants.COMMA);
                    }
                    w.write(String.valueOf(ImportConstants.LABEL_TYPE_LABEL) + ImportConstants.QUOTE + iData.matrixFiles.get((int)0).col_datatype + ImportConstants.QUOTE + ImportConstants.COMMA);
                    w.write(ImportConstants.LABELS_LABEL);
                    w.write(ImportConstants.BRACKET_OPEN);
                    int col = 1;
                    while (col < iData.importCols + 1) {
                        w.write(String.valueOf(ImportConstants.QUOTE) + iData.reorgMatrix[0][col] + ImportConstants.QUOTE);
                        if (col < iData.importCols) {
                            w.write(ImportConstants.COMMA);
                        }
                        ++col;
                    }
                }
                w.write(String.valueOf(ImportConstants.BRACKET_CLOSE) + ImportConstants.BRACE_CLOSE);
                w.close();
                writeRow.close();
            }
            catch (Exception ex) {
                System.out.println("Exception: " + ex.toString());
                try {
                    w.close();
                    writeRow.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                w.close();
                writeRow.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void writeClusteredDebugFile(ImportData iData) {
        FilterOutputStream writeRow = null;
        OutputStreamWriter w = null;
        try {
            try {
                writeRow = new DataOutputStream(new FileOutputStream(String.valueOf(iData.outputDir) + File.separator + "clustered.txt"));
                w = new OutputStreamWriter((OutputStream)writeRow, ImportConstants.UTF8);
                int row = 1;
                while (row < iData.importRows + 1) {
                    int col = 1;
                    while (col < iData.importCols + 1) {
                        w.write(iData.reorgMatrix[row][col]);
                        if (col < iData.importCols) {
                            w.write(ImportConstants.TAB);
                        } else {
                            w.write(ImportConstants.LINE_FEED);
                        }
                        ++col;
                    }
                    ++row;
                }
                w.close();
                writeRow.close();
            }
            catch (Exception ex) {
                System.out.println("Exception: " + ex.toString());
                try {
                    w.close();
                    writeRow.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                w.close();
                writeRow.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void writeDendrogramFile(ImportData iData, int interval) {
        try {
            DataOutputStream writer = new DataOutputStream(new FileOutputStream(String.valueOf(iData.outputDir) + File.separator + ImportConstants.DENDROGRAM_FILE));
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)writer, ImportConstants.UTF8);
            fw.write(ImportConstants.BRACE_OPEN);
            if (iData.rowData.dendroFile != null) {
                fw.write(String.valueOf(ImportConstants.ROW_DENDRO_SHOW_LABEL) + ImportConstants.QUOTE + "ALL" + ImportConstants.QUOTE + ImportConstants.COMMA);
                fw.write(String.valueOf(ImportConstants.ROW_DENDRO_HEIGHT_LABEL) + ImportConstants.QUOTE + "100" + ImportConstants.QUOTE + ImportConstants.COMMA);
                HeatmapDataGenerator.populateDendrogramFile(iData.rowData.orderArray, iData.rowData.dendroFile, ImportConstants.ROW, fw);
                fw.write(String.valueOf(ImportConstants.BRACKET_CLOSE) + ImportConstants.COMMA);
            } else {
                fw.write(String.valueOf(ImportConstants.ROW_DENDRO_SHOW_LABEL) + ImportConstants.QUOTE + "NA" + ImportConstants.QUOTE + ImportConstants.COMMA);
                fw.write(String.valueOf(ImportConstants.ROW_DENDRO_HEIGHT_LABEL) + ImportConstants.QUOTE + "10" + ImportConstants.QUOTE + ImportConstants.COMMA);
            }
            if (iData.colData.dendroFile != null) {
                fw.write(String.valueOf(ImportConstants.COL_DENDRO_SHOW_LABEL) + ImportConstants.QUOTE + "ALL" + ImportConstants.QUOTE + ImportConstants.COMMA);
                fw.write(String.valueOf(ImportConstants.COL_DENDRO_HEIGHT_LABEL) + ImportConstants.QUOTE + "100" + ImportConstants.QUOTE + ImportConstants.COMMA);
                HeatmapDataGenerator.populateDendrogramFile(iData.colData.orderArray, iData.colData.dendroFile, ImportConstants.COL, fw);
                fw.write(ImportConstants.BRACKET_CLOSE);
            } else {
                fw.write(String.valueOf(ImportConstants.COL_DENDRO_SHOW_LABEL) + ImportConstants.QUOTE + "NA" + ImportConstants.QUOTE + ImportConstants.COMMA);
                fw.write(String.valueOf(ImportConstants.COL_DENDRO_HEIGHT_LABEL) + ImportConstants.QUOTE + "10" + ImportConstants.QUOTE);
            }
            fw.write(ImportConstants.BRACE_CLOSE);
            fw.close();
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }

    private static void populateDendrogramFile(int[] order, String dendroFile, String dendroType, OutputStreamWriter fw) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(dendroFile));
            String line = br.readLine();
            line = br.readLine();
            boolean firstTimeThrough = true;
            fw.write(String.valueOf(ImportConstants.QUOTE) + dendroType + ImportConstants.QUOTE + ImportConstants.SPACE + ImportConstants.COLON + ImportConstants.BRACKET_OPEN);
            while (line != null) {
                String[] tokes = line.split(ImportConstants.TAB);
                int a = Integer.parseInt(tokes[0]);
                int b = Integer.parseInt(tokes[1]);
                if (a < 0) {
                    a = 0 - order[0 - a];
                }
                if (b < 0) {
                    b = 0 - order[0 - b];
                }
                if (firstTimeThrough) {
                    firstTimeThrough = false;
                } else {
                    fw.write(ImportConstants.COMMA);
                }
                fw.write(String.valueOf(ImportConstants.QUOTE) + a + ImportConstants.COMMA + b + ImportConstants.COMMA + tokes[2] + ImportConstants.QUOTE);
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }

    private static void writeClassificationsFile(ImportData iData, int interval) {
        try {
            DataOutputStream writer = new DataOutputStream(new FileOutputStream(String.valueOf(iData.outputDir) + File.separator + ImportConstants.CLASSIFICATIONS_FILE));
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)writer, ImportConstants.UTF8);
            if (iData.colClassFiles.size() + iData.rowClassFiles.size() == 0) {
                fw.write(String.valueOf(ImportConstants.BRACE_OPEN) + ImportConstants.BRACE_CLOSE);
            } else {
                String[][] reOrgClass;
                InputFile currInput;
                fw.write(ImportConstants.BRACE_OPEN);
                int i = 0;
                while (i < iData.colClassFiles.size()) {
                    currInput = iData.colClassFiles.get(i);
                    reOrgClass = HeatmapDataGenerator.reOrderClassificationFile(currInput, iData.colData.orderArray);
                    HeatmapDataGenerator.populateClassificationsFile(currInput, reOrgClass, fw, interval);
                    if (i != iData.colClassFiles.size() - 1 || iData.rowClassFiles.size() > 0) {
                        fw.write(String.valueOf(ImportConstants.BRACE_CLOSE) + ImportConstants.COMMA);
                    }
                    ++i;
                }
                i = 0;
                while (i < iData.rowClassFiles.size()) {
                    currInput = iData.rowClassFiles.get(i);
                    reOrgClass = HeatmapDataGenerator.reOrderClassificationFile(currInput, iData.rowData.orderArray);
                    HeatmapDataGenerator.populateClassificationsFile(currInput, reOrgClass, fw, interval);
                    ++i;
                }
                fw.write(String.valueOf(ImportConstants.BRACE_CLOSE) + ImportConstants.BRACE_CLOSE);
            }
            fw.close();
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }

    private static String[][] reOrderClassificationFile(InputFile inputFile, int[] order) {
        String[][] reorg = new String[order.length][2];
        try {
            BufferedReader br = new BufferedReader(new FileReader(inputFile.file));
            String line = br.readLine();
            String[][] origClass = new String[order.length][2];
            int pos = 1;
            while (line != null) {
                String[] toks = line.split("\t");
                int i = 0;
                while (i < toks.length) {
                    origClass[pos][i] = toks[i];
                    ++i;
                }
                ++pos;
                line = br.readLine();
            }
            br.close();
            int row = 0;
            while (row < order.length) {
                reorg[order[row]] = origClass[row];
                ++row;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
        return reorg;
    }

    private static void populateClassificationsFile(InputFile currFile, String[][] classData, OutputStreamWriter fw, int interval) {
        try {
            ColorMap cMap = currFile.getMap();
            fw.write(String.valueOf(ImportConstants.QUOTE) + currFile.name + ImportConstants.QUOTE + ImportConstants.COLON + ImportConstants.LINE_FEED + ImportConstants.BRACE_OPEN);
            fw.write(String.valueOf(ImportConstants.QUOTE) + "position" + ImportConstants.QUOTE + ImportConstants.COLON + ImportConstants.QUOTE + currFile.position + ImportConstants.QUOTE + ImportConstants.COMMA);
            fw.write(String.valueOf(ImportConstants.QUOTE) + "height" + ImportConstants.QUOTE + ImportConstants.COLON + "15" + ImportConstants.COMMA);
            fw.write(String.valueOf(ImportConstants.QUOTE) + "colorScheme" + ImportConstants.QUOTE + ImportConstants.COLON + ImportConstants.QUOTE + cMap.id + ImportConstants.QUOTE + ImportConstants.COMMA);
            fw.write(String.valueOf(ImportConstants.QUOTE) + "show" + ImportConstants.QUOTE + ImportConstants.COLON + ImportConstants.QUOTE + "Y" + ImportConstants.QUOTE + ImportConstants.COMMA);
            fw.write(String.valueOf(ImportConstants.QUOTE) + "values" + ImportConstants.QUOTE + ImportConstants.COLON + ImportConstants.LINE_FEED + ImportConstants.TAB + ImportConstants.TAB + ImportConstants.BRACKET_OPEN);
            int row = 1;
            while (row < classData.length) {
                HeatmapDataGenerator.writeClassValue(classData[row][1], row, classData.length, fw, 1);
                ++row;
            }
            if (interval > 1) {
                fw.write(String.valueOf(ImportConstants.COMMA) + ImportConstants.QUOTE + "svalues" + ImportConstants.QUOTE + ImportConstants.COLON + ImportConstants.LINE_FEED + ImportConstants.BRACKET_OPEN);
                row = 1;
                while (row < classData.length) {
                    int adjustedPos = row - 1;
                    float remainder = (float)adjustedPos / (float)interval % 1.0f;
                    if (remainder == 0.0f) {
                        HeatmapDataGenerator.writeClassValue(classData[row][1], row, classData.length, fw, interval);
                    }
                    ++row;
                }
            }
            fw.write(ImportConstants.LINE_FEED);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }

    private static void writeClassValue(String val, int row, int len, OutputStreamWriter fw, int interval) {
        block7: {
            try {
                if (HeatmapDataGenerator.isNumeric(val)) {
                    fw.write(val);
                } else {
                    fw.write(String.valueOf(ImportConstants.QUOTE) + val + ImportConstants.QUOTE);
                }
                if (row + interval < len) {
                    fw.write(ImportConstants.COMMA);
                    break block7;
                }
                fw.write(ImportConstants.BRACKET_CLOSE);
            }
            catch (Exception ex) {
                System.out.println("Exception: " + ex.toString());
            }
        }
    }

    private static void writeColorMapFile(ImportData iData) {
        try {
            InputFile currInput;
            DataOutputStream writer = new DataOutputStream(new FileOutputStream(String.valueOf(iData.outputDir) + File.separator + ImportConstants.COLORMAPS_FILE));
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)writer, ImportConstants.UTF8);
            fw.write(String.valueOf(ImportConstants.BRACE_OPEN) + ImportConstants.COLORMAPS_LABEL + ImportConstants.BRACE_OPEN);
            InputFile iFile = iData.matrixFiles.get(0);
            ColorMap cMap = iFile.getMap();
            fw.write(cMap.asJSON());
            if (iData.colClassFiles.size() + iData.rowClassFiles.size() > 0) {
                fw.write(ImportConstants.COMMA);
            }
            int i = 0;
            while (i < iData.colClassFiles.size()) {
                currInput = iData.colClassFiles.get(i);
                ColorMap currColFile = currInput.getMap();
                fw.write(currColFile.asJSON());
                if (i != iData.colClassFiles.size() - 1 || iData.rowClassFiles.size() > 0) {
                    fw.write(ImportConstants.COMMA);
                }
                ++i;
            }
            i = 0;
            while (i < iData.rowClassFiles.size()) {
                currInput = iData.rowClassFiles.get(i);
                ColorMap currRowFile = currInput.getMap();
                fw.write(currRowFile.asJSON());
                if (i != iData.rowClassFiles.size() - 1) {
                    fw.write(ImportConstants.COMMA);
                }
                ++i;
            }
            fw.write(String.valueOf(ImportConstants.BRACE_CLOSE) + ImportConstants.BRACE_CLOSE);
            fw.close();
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }

    private static void writeChmFile(ImportData iData) {
        try {
            DataOutputStream writer = new DataOutputStream(new FileOutputStream(String.valueOf(iData.outputDir) + File.separator + ImportConstants.CHM_FILE));
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)writer, ImportConstants.UTF8);
            fw.write(String.valueOf(ImportConstants.BRACE_OPEN) + ImportConstants.NAME_LABEL + ImportConstants.QUOTE + iData.chmName + ImportConstants.QUOTE + ImportConstants.COMMA);
            fw.write(String.valueOf(ImportConstants.DESC_LABEL) + ImportConstants.QUOTE + iData.chmDescription + ImportConstants.QUOTE + ImportConstants.COMMA);
            fw.write(String.valueOf(ImportConstants.ATTRS_LABEL) + ImportConstants.BRACKET_OPEN + ImportConstants.BRACE_OPEN);
            int i = 0;
            while (i < iData.chmAttributes.size()) {
                AttributeData ad = iData.chmAttributes.get(i);
                fw.write(String.valueOf(ImportConstants.QUOTE) + ad.attributeName + ImportConstants.QUOTE + ImportConstants.COLON + ImportConstants.QUOTE + ad.attributeValue + ImportConstants.QUOTE);
                if (i != iData.chmAttributes.size() - 1) {
                    fw.write(ImportConstants.COMMA);
                }
                ++i;
            }
            fw.write(String.valueOf(ImportConstants.BRACE_CLOSE) + ImportConstants.BRACKET_CLOSE + ImportConstants.BRACE_CLOSE);
            fw.close();
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }
}

