/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.Random;

public class genTestMatrix {
    public static int NUM_ROWS = 0;
    public static int NUM_COLS = 0;
    public static Random rnd = new Random();

    public static void randomizeCol(float[] columnData) {
        int i = 0;
        while (i < columnData.length) {
            if ((double)rnd.nextFloat() < 0.85) {
                columnData[i] = rnd.nextFloat() * 2.0f - 1.0f;
            }
            ++i;
        }
    }

    public static void randomizeColSmall(float[] columnData) {
        int i = 0;
        while (i < columnData.length) {
            if ((double)rnd.nextFloat() < 0.1) {
                columnData[i] = rnd.nextFloat() * 2.0f - 1.0f;
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        int j;
        System.out.println("START: " + new Date());
        NUM_ROWS = Integer.parseInt(args[0]);
        NUM_COLS = Integer.parseInt(args[1]);
        String filename = String.valueOf(NUM_ROWS) + "x" + NUM_COLS;
        float[][] matrix = new float[NUM_ROWS][NUM_COLS];
        float[] columnData = new float[NUM_ROWS];
        File dataDir = new File("C:\\NGCHMProto\\" + filename);
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        BufferedWriter write = new BufferedWriter(new FileWriter("C:\\NGCHMProto\\" + filename + "\\" + filename + ".txt"));
        genTestMatrix.randomizeCol(columnData);
        write.write("\tSAMP_1");
        int i = 1;
        while (i < NUM_COLS) {
            write.write("\tSAMP_" + (i + 1));
            ++i;
        }
        write.write("\n");
        i = 0;
        while (i < NUM_COLS) {
            j = 0;
            while (j < NUM_ROWS) {
                matrix[j][i] = (double)rnd.nextFloat() < 0.3 ? rnd.nextFloat() * 2.0f - 1.0f : columnData[j] + (rnd.nextFloat() * 0.6f - 0.3f);
                ++j;
            }
            if ((double)i == (double)NUM_COLS / 0.4 || (double)i == (double)NUM_COLS / 0.7 || (double)i == (double)NUM_COLS * 0.85) {
                genTestMatrix.randomizeCol(columnData);
            }
            if (rnd.nextFloat() < 0.15f) {
                genTestMatrix.randomizeColSmall(columnData);
            }
            ++i;
        }
        i = 0;
        while (i < NUM_ROWS) {
            write.write("Gene_" + (i + 1));
            j = 0;
            while (j < NUM_COLS) {
                write.write("\t" + String.format("%.4f", Float.valueOf(matrix[i][j])));
                ++j;
            }
            write.write("\n");
            ++i;
        }
        write.close();
        write = new BufferedWriter(new FileWriter("C:\\NGCHMProto\\" + filename + "\\Smoker_ColClassification.txt"));
        write.write("Discrete\n");
        i = 0;
        while (i < NUM_COLS) {
            String cat = (double)i < (double)NUM_COLS / 0.4 ? ((double)rnd.nextFloat() < 0.85 ? "Smoker" : "Non-Smoker") : ((double)rnd.nextFloat() < 0.15 ? "Smoker" : "Non-Smoker");
            write.write("TCGA_SAMP_" + (i + 1) + "\t" + cat + "\n");
            ++i;
        }
        write.close();
        write = new BufferedWriter(new FileWriter("C:\\NGCHMProto\\" + filename + "\\Age_ColClassification.txt"));
        write.write("Continuous\n");
        i = 0;
        while (i < NUM_COLS) {
            write.write("TCGA_SAMP_" + (i + 1) + "\t" + (rnd.nextInt(70) + 20) + "\n");
            ++i;
        }
        write.close();
        write = new BufferedWriter(new FileWriter("C:\\NGCHMProto\\" + filename + "\\Type_RowClassification.txt"));
        write.write("Discrete\n");
        i = 0;
        while (i < NUM_ROWS) {
            String cat = "Type_" + (rnd.nextInt(4) + 1);
            write.write("Gene_" + (i + 1) + "\t" + cat + "\n");
            ++i;
        }
        write.close();
        System.out.println("END: " + new Date());
    }
}

