/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.datagenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mda.ngchm.datagenerator.AttributeData;
import mda.ngchm.datagenerator.ImportConstants;
import mda.ngchm.datagenerator.ImportLayerData;
import mda.ngchm.datagenerator.InputFile;
import mda.ngchm.datagenerator.RowColData;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ImportData {
    public String chmName;
    public String chmDescription;
    public ArrayList<AttributeData> chmAttributes = new ArrayList();
    public String outputDir;
    public List<InputFile> matrixFiles = new ArrayList<InputFile>();
    public String summaryMethod;
    public int importRows;
    public int importCols;
    public ArrayList<ImportLayerData> importLayers = new ArrayList();
    public RowColData rowData;
    public RowColData colData;
    public String[][] reorgMatrix;
    public List<InputFile> rowClassFiles = new ArrayList<InputFile>();
    public List<InputFile> colClassFiles = new ArrayList<InputFile>();

    public ImportData(String[] fileInfo) {
        this.setHeatmapProperties(new File(fileInfo[0]));
        this.reorgMatrix = new String[this.importRows + 1][this.importCols + 1];
        this.setReorderedInputMatrix();
        ImportLayerData ild = new ImportLayerData(ImportConstants.LAYER_THUMBNAIL, this.importRows, this.importCols);
        this.importLayers.add(ild);
        if (ild.rowInterval > 1 || ild.colInterval > 1) {
            ild = new ImportLayerData(ImportConstants.LAYER_SUMMARY, this.importRows, this.importCols);
            this.importLayers.add(ild);
            if (ild.rowInterval > 1 || ild.colInterval > 1) {
                ild = new ImportLayerData(ImportConstants.LAYER_DETAIL, this.importRows, this.importCols);
                this.importLayers.add(ild);
                ild = new ImportLayerData(ImportConstants.LAYER_RIBBONVERT, this.importRows, this.importCols);
                this.importLayers.add(ild);
                ild = new ImportLayerData(ImportConstants.LAYER_RIBBONHORIZ, this.importRows, this.importCols);
                this.importLayers.add(ild);
            }
        }
    }

    private void setInputFileRowCols() {
        int rowId = 0;
        BufferedReader br = null;
        try {
            try {
                String sCurrentLine;
                InputFile matrixFile = this.matrixFiles.get(0);
                br = new BufferedReader(new FileReader(new File(matrixFile.file)));
                while ((sCurrentLine = br.readLine()) != null) {
                    if (++rowId != 2) continue;
                    String[] vals = sCurrentLine.split("\t");
                    this.importCols = vals.length - 1;
                }
                br.close();
                this.importRows = rowId - 1;
            }
            catch (Exception ex) {
                System.out.println("Exception: " + ex.toString());
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    private void setHeatmapProperties(File filename) {
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(new FileReader(filename));
            JSONObject jsonObject = (JSONObject)obj;
            this.chmName = (String)jsonObject.get(ImportConstants.CHM_NAME);
            this.chmDescription = (String)jsonObject.get(ImportConstants.CHM_DESC);
            JSONArray tags = (JSONArray)jsonObject.get(ImportConstants.CHM_ATTRS);
            int i = 0;
            while (i < tags.size()) {
                JSONObject jo = (JSONObject)tags.get(i);
                Set keyset = jo.keySet();
                for (String elem : keyset) {
                    String elemVal = (String)jo.get(elem);
                    AttributeData aData = new AttributeData(elem, elemVal);
                    this.chmAttributes.add(aData);
                }
                ++i;
            }
            JSONArray matrixfiles = (JSONArray)jsonObject.get(ImportConstants.MATRIX_FILES);
            int i2 = 0;
            while (i2 < matrixfiles.size()) {
                JSONObject jo = (JSONObject)matrixfiles.get(i2);
                InputFile iFile = new InputFile((String)jo.get(ImportConstants.NAME), String.valueOf(ImportConstants.DATA_LAYER) + (i2 + 1), (String)jo.get(ImportConstants.PATH), (String)jo.get(ImportConstants.COLOR_TYPE), String.valueOf(ImportConstants.DATA_POSITION) + (i2 + 1), (String)jo.get(ImportConstants.ROW_DATATYPE), (String)jo.get(ImportConstants.COL_DATATYPE));
                this.matrixFiles.add(iFile);
                ++i2;
            }
            this.setInputFileRowCols();
            this.summaryMethod = (String)jsonObject.get(ImportConstants.SUMMARY_METHOD);
            JSONObject rowConfigData = (JSONObject)jsonObject.get(ImportConstants.ROW_CONFIGURATION);
            this.rowData = this.setRowColData(ImportConstants.ROW, this.importRows, rowConfigData);
            JSONObject colConfigData = (JSONObject)jsonObject.get(ImportConstants.COL_CONFIGURATION);
            this.colData = this.setRowColData(ImportConstants.COL, this.importCols, colConfigData);
            this.outputDir = (String)jsonObject.get(ImportConstants.OUTPUT_LOC);
            JSONArray classfiles = (JSONArray)jsonObject.get(ImportConstants.CLASS_FILES);
            int rowCtr = 0;
            int colCtr = 0;
            int i3 = 0;
            while (i3 < classfiles.size()) {
                InputFile iFile;
                String id;
                JSONObject jo = (JSONObject)classfiles.get(i3);
                String pos = (String)jo.get(ImportConstants.POSITION);
                if (pos.equals("row")) {
                    id = String.valueOf(ImportConstants.ROW_CLASS) + ++rowCtr;
                    iFile = new InputFile((String)jo.get(ImportConstants.NAME), id, (String)jo.get(ImportConstants.PATH), (String)jo.get(ImportConstants.COLOR_TYPE), pos);
                    this.rowClassFiles.add(iFile);
                } else {
                    id = String.valueOf(ImportConstants.COL_CLASS) + ++colCtr;
                    iFile = new InputFile((String)jo.get(ImportConstants.NAME), id, (String)jo.get(ImportConstants.PATH), (String)jo.get(ImportConstants.COLOR_TYPE), pos);
                    this.colClassFiles.add(iFile);
                }
                ++i3;
            }
        }
        catch (FileNotFoundException obj) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private RowColData setRowColData(String type, int rowColSize, JSONObject configData) {
        String order = (String)configData.get(ImportConstants.ORDER_METHOD);
        RowColData rcData = ImportConstants.ORDER_HIERARCHICAL.equals(order) ? new RowColData(type, rowColSize, (String)configData.get(ImportConstants.ORDER_FILE), (String)configData.get(ImportConstants.ORDER_METHOD), (String)configData.get(ImportConstants.DISTANCE_METRIC), (String)configData.get(ImportConstants.AGGLOMERATION_METHOD), (String)configData.get(ImportConstants.DENDRO_FILE)) : new RowColData(type, rowColSize, (String)configData.get(ImportConstants.ORDER_FILE), (String)configData.get(ImportConstants.ORDER_METHOD));
        return rcData;
    }

    private void setReorderedInputMatrix() {
        int rows = this.importRows + 1;
        int cols = this.importCols + 1;
        try {
            InputFile matrixFile = this.matrixFiles.get(0);
            new File(matrixFile.file).exists();
            BufferedReader read = new BufferedReader(new FileReader(new File(matrixFile.file)));
            String[][] matrix = new String[rows][cols];
            String line = read.readLine();
            int pos = 0;
            while (line != null) {
                String[] toks = line.split("\t");
                int i = 0;
                while (i < toks.length) {
                    matrix[pos][i] = toks[i];
                    ++i;
                }
                ++pos;
                line = read.readLine();
            }
            read.close();
            String[][] reorg = new String[rows][cols];
            int row = 0;
            while (row < reorg.length) {
                reorg[this.rowData.orderArray[row]] = matrix[row];
                ++row;
            }
            int col = 0;
            while (col < reorg[0].length) {
                int newCol = this.colData.orderArray[col];
                int row2 = 0;
                while (row2 < reorg.length) {
                    this.reorgMatrix[row2][newCol] = reorg[row2][col];
                    ++row2;
                }
                ++col;
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

