/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.datagenerator;

import java.util.ArrayList;
import mda.ngchm.datagenerator.ImportConstants;
import mda.ngchm.datagenerator.ImportTileData;

public class ImportLayerData {
    public String layer;
    public int rowInterval = 1;
    public int colInterval = 1;
    public int rowTiles;
    public int colTiles;
    public int rowsPerTile;
    public int colsPerTile;
    public int totalLevelRows;
    public int totalLevelCols;
    public int importRows;
    public int importCols;
    public ArrayList<ImportTileData> importTiles = new ArrayList();

    public ImportLayerData(String level, int ir, int ic) {
        this.layer = level;
        this.importRows = ir;
        this.importCols = ic;
        this.configureLayer(this.layer);
        int i = 0;
        while (i < this.colTiles) {
            int j = 0;
            while (j < this.rowTiles) {
                this.importTiles.add(new ImportTileData(this, i, j));
                ++j;
            }
            ++i;
        }
    }

    private void configureLayer(String layer) {
        switch (layer) {
            case "tn": {
                this.rowTiles = 1;
                this.colTiles = 1;
                this.setCombinedInterval(ImportConstants.THUMB_SIZE);
                this.rowsPerTile = 1 + (this.importRows - 1) / this.rowInterval;
                this.colsPerTile = 1 + (this.importCols - 1) / this.colInterval;
                this.totalLevelRows = this.rowsPerTile;
                this.totalLevelCols = this.colsPerTile;
                break;
            }
            case "s": {
                this.setCombinedInterval(ImportConstants.SUMMARY_SIZE);
                this.rowTiles = this.importRows / this.rowInterval <= ImportConstants.TILE_SIZE ? 1 : 2;
                this.colTiles = this.importCols / this.colInterval <= ImportConstants.TILE_SIZE ? 1 : 2;
                this.totalLevelRows = this.setLayerValue(this.importRows, this.rowInterval);
                this.totalLevelCols = this.setLayerValue(this.importCols, this.colInterval);
                this.rowsPerTile = this.setLayerValue(this.totalLevelRows, this.rowTiles);
                this.colsPerTile = this.setLayerValue(this.totalLevelCols, this.colTiles);
                break;
            }
            case "d": {
                this.rowTiles = this.importRows <= ImportConstants.TILE_SIZE ? 1 : this.setLayerValue(this.importRows, ImportConstants.TILE_SIZE);
                this.colTiles = this.importCols <= ImportConstants.TILE_SIZE ? 1 : this.setLayerValue(this.importCols, ImportConstants.TILE_SIZE);
                this.totalLevelRows = this.importRows;
                this.totalLevelCols = this.importCols;
                this.rowsPerTile = ImportConstants.TILE_SIZE;
                this.colsPerTile = ImportConstants.TILE_SIZE;
                break;
            }
            case "rv": {
                this.setRowInterval(ImportConstants.SUMMARY_SIZE);
                this.rowTiles = this.importRows <= ImportConstants.TILE_SIZE ? 1 : 2;
                this.colTiles = this.importCols <= ImportConstants.TILE_SIZE ? 1 : this.setLayerValue(this.importCols, ImportConstants.TILE_SIZE);
                this.totalLevelRows = this.setLayerValue(this.importRows, this.rowInterval);
                this.totalLevelCols = this.importCols;
                this.rowsPerTile = this.setLayerValue(this.totalLevelRows, this.rowTiles);
                this.colsPerTile = ImportConstants.TILE_SIZE;
                break;
            }
            case "rh": {
                this.setColInterval(ImportConstants.SUMMARY_SIZE);
                this.colTiles = this.importCols <= ImportConstants.TILE_SIZE ? 1 : 2;
                this.rowTiles = this.importRows <= ImportConstants.TILE_SIZE ? 1 : this.setLayerValue(this.importRows, ImportConstants.TILE_SIZE);
                this.totalLevelRows = this.importRows;
                this.totalLevelCols = this.setLayerValue(this.importCols, this.colInterval);
                this.rowsPerTile = ImportConstants.TILE_SIZE;
                this.colsPerTile = this.setLayerValue(this.totalLevelCols, this.colTiles);
            }
        }
    }

    private int setLayerValue(int numerator, int denominator) {
        int returnVal = numerator / denominator;
        float remainder = this.getRemainder(numerator, denominator);
        if (remainder > 0.0f) {
            ++returnVal;
        }
        return returnVal;
    }

    private float getRemainder(int numerator, int denominator) {
        float intercalc = (float)numerator / (float)denominator;
        float remainder = intercalc % 1.0f;
        return remainder;
    }

    private void setCombinedInterval(int sizeLimit) {
        this.setRowInterval(sizeLimit);
        this.setColInterval(sizeLimit);
        if (this.rowInterval + this.colInterval > 0) {
            this.rowInterval = this.rowInterval > this.colInterval ? this.rowInterval : this.colInterval;
            this.colInterval = this.rowInterval > this.colInterval ? this.rowInterval : this.colInterval;
        }
    }

    private void setRowInterval(int sizeLimit) {
        int rows = this.importRows;
        this.rowInterval = rows / sizeLimit;
        float remainder = this.getRemainder(rows, sizeLimit);
        if ((double)remainder >= 0.5 || this.rowInterval == 0) {
            ++this.rowInterval;
        }
    }

    private void setColInterval(int sizeLimit) {
        int cols = this.importCols;
        this.colInterval = cols / sizeLimit;
        float remainder = this.getRemainder(cols, sizeLimit);
        if ((double)remainder >= 0.5 || this.colInterval == 0) {
            ++this.colInterval;
        }
    }
}

