/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.Slice;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CRAIEntry
implements Comparable<CRAIEntry>,
Cloneable {
    public int sequenceId;
    public int alignmentStart;
    public int alignmentSpan;
    public long containerStartOffset;
    public int sliceOffset;
    public int sliceSize;
    public int sliceIndex;
    public static Comparator<CRAIEntry> byEnd = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry o1, CRAIEntry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                return o2.sequenceId - o1.sequenceId;
            }
            if (o1.alignmentStart + o1.alignmentSpan != o2.alignmentStart + o2.alignmentSpan) {
                return o1.alignmentStart + o1.alignmentSpan - o2.alignmentStart - o2.alignmentSpan;
            }
            return (int)(o1.containerStartOffset - o2.containerStartOffset);
        }
    };
    public static final Comparator<CRAIEntry> byStart = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry o1, CRAIEntry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                return o2.sequenceId - o1.sequenceId;
            }
            if (o1.alignmentStart != o2.alignmentStart) {
                return o1.alignmentStart - o2.alignmentStart;
            }
            return (int)(o1.containerStartOffset - o2.containerStartOffset);
        }
    };

    public CRAIEntry() {
    }

    public static List<CRAIEntry> fromContainer(Container container) {
        ArrayList<CRAIEntry> entries = new ArrayList<CRAIEntry>(container.slices.length);
        int i = 0;
        while (i < container.slices.length) {
            Slice s = container.slices[i];
            CRAIEntry e = new CRAIEntry();
            e.sequenceId = s.sequenceId;
            e.alignmentStart = s.alignmentStart;
            e.alignmentSpan = s.alignmentSpan;
            e.containerStartOffset = s.containerOffset;
            e.sliceOffset = container.landmarks[i];
            e.sliceSize = s.size;
            e.sliceIndex = i++;
            entries.add(e);
        }
        return entries;
    }

    public static CRAIEntry fromCraiLine(String line) {
        String[] chunks = line.split("\t");
        if (chunks.length != 6) {
            throw new CRAIIndex.CRAIIndexException("Expecting 6 columns but got " + chunks.length);
        }
        try {
            CRAIEntry e = new CRAIEntry();
            e.sequenceId = Integer.valueOf(chunks[0]);
            e.alignmentStart = Integer.valueOf(chunks[1]);
            e.alignmentSpan = Integer.valueOf(chunks[2]);
            e.containerStartOffset = Integer.valueOf(chunks[3]).intValue();
            e.sliceOffset = Integer.valueOf(chunks[4]);
            e.sliceSize = Integer.valueOf(chunks[5]);
            return e;
        }
        catch (NumberFormatException e) {
            throw new CRAIIndex.CRAIIndexException(e);
        }
    }

    public CRAIEntry(String line) throws CRAIIndex.CRAIIndexException {
        String[] chunks = line.split("\t");
        if (chunks.length != 6) {
            throw new CRAIIndex.CRAIIndexException("Expecting 6 columns but got " + chunks.length);
        }
        try {
            this.sequenceId = Integer.valueOf(chunks[0]);
            this.alignmentStart = Integer.valueOf(chunks[1]);
            this.alignmentSpan = Integer.valueOf(chunks[2]);
            this.containerStartOffset = Integer.valueOf(chunks[3]).intValue();
            this.sliceOffset = Integer.valueOf(chunks[4]);
            this.sliceSize = Integer.valueOf(chunks[5]);
        }
        catch (NumberFormatException e) {
            throw new CRAIIndex.CRAIIndexException(e);
        }
    }

    public String toString() {
        return String.format("%d\t%d\t%d\t%d\t%d\t%d", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.containerStartOffset, this.sliceOffset, this.sliceSize);
    }

    @Override
    public int compareTo(CRAIEntry o) {
        if (o == null) {
            return 1;
        }
        if (this.sequenceId != o.sequenceId) {
            return this.sequenceId - o.sequenceId;
        }
        if (this.alignmentStart != o.alignmentStart) {
            return this.alignmentStart - o.alignmentStart;
        }
        return (int)(this.containerStartOffset - o.containerStartOffset);
    }

    public CRAIEntry clone() throws CloneNotSupportedException {
        super.clone();
        CRAIEntry entry = new CRAIEntry();
        entry.sequenceId = this.sequenceId;
        entry.alignmentStart = this.alignmentStart;
        entry.alignmentSpan = this.alignmentSpan;
        entry.containerStartOffset = this.containerStartOffset;
        entry.sliceOffset = this.sliceOffset;
        entry.sliceSize = this.sliceSize;
        return entry;
    }

    public static boolean intersect(CRAIEntry e0, CRAIEntry e1) {
        if (e0.sequenceId != e1.sequenceId) {
            return false;
        }
        if (e0.sequenceId < 0) {
            return false;
        }
        int a0 = e0.alignmentStart;
        int b0 = a0 + e0.alignmentSpan;
        int a1 = e1.alignmentStart;
        int b1 = a1 + e1.alignmentSpan;
        return Math.abs(a0 + b0 - a1 - b1) < e0.alignmentSpan + e1.alignmentSpan;
    }
}

