/*
 * Decompiled with CFR 0.152.
 */
package PileupScripts;

public class TransformArray {
    public static double[] reverseTran(double[] orig) {
        if (orig != null) {
            double[] reverse = new double[orig.length];
            int x = orig.length - 1;
            while (x >= 0) {
                reverse[orig.length - 1 - x] = orig[x];
                --x;
            }
            return reverse;
        }
        return null;
    }

    public static double[] smoothTran(double[] orig, int win) {
        int window = win / 2;
        double[] Sarray = new double[orig.length];
        int x = 0;
        while (x < orig.length) {
            double score = 0.0;
            double weight = 0.0;
            int y = x - window;
            while (y <= x + window) {
                if (y < 0) {
                    y = -1;
                } else if (y < orig.length) {
                    score += orig[y];
                    weight += 1.0;
                } else {
                    y = x + window + 1;
                }
                ++y;
            }
            if (weight != 0.0) {
                Sarray[x] = score / weight;
            }
            ++x;
        }
        return Sarray;
    }

    public static double[] gaussTran(double[] orig, int size, int num) {
        double[] Garray = new double[orig.length];
        int window = size * num;
        double SDSize = size;
        int x = 0;
        while (x < orig.length) {
            double score = 0.0;
            double weight = 0.0;
            int y = x - window;
            while (y <= x + window) {
                if (y < 0) {
                    y = -1;
                } else if (y < orig.length) {
                    double HEIGHT = Math.exp(-1.0 * Math.pow(y - x, 2.0) / (2.0 * Math.pow(SDSize, 2.0)));
                    score += HEIGHT * orig[y];
                    weight += HEIGHT;
                } else {
                    y = x + window + 1;
                }
                ++y;
            }
            if (weight != 0.0) {
                Garray[x] = score / weight;
            }
            ++x;
        }
        return Garray;
    }
}

