/*
 * Decompiled with CFR 0.152.
 */
package projects.crispr;

import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import projects.crispr.PositionPrior;

public class LogisticPositionPrior2
implements PositionPrior {
    private double a;
    private double b;
    private boolean fixA;
    private boolean fixB;

    public LogisticPositionPrior2(Double a, Double b) {
        if (a == null) {
            this.fixA = false;
        } else {
            this.a = a;
            this.fixA = true;
        }
        if (b == null) {
            this.fixB = false;
        } else {
            this.b = b;
            this.fixB = true;
        }
    }

    @Override
    public LogisticPositionPrior2 clone() throws CloneNotSupportedException {
        return (LogisticPositionPrior2)super.clone();
    }

    @Override
    public double getLogScore(int position) {
        return -Math.log1p(Math.exp(-Math.exp(this.a) * ((double)position - this.b)));
    }

    @Override
    public double getLogScoreAndPartialDerivation(int position, IntList indices, DoubleList partialDer) {
        double sc = this.getLogScore(position);
        double v = -Math.exp(sc) * Math.exp(-Math.exp(this.a) * ((double)position - this.b));
        int i = 0;
        if (!this.fixA) {
            indices.add(i);
            partialDer.add(v * -Math.exp(this.a) * ((double)position - this.b));
            ++i;
        }
        if (!this.fixB) {
            indices.add(i);
            partialDer.add(v * Math.exp(this.a));
        }
        return sc;
    }

    @Override
    public int getNumberOfParameters() {
        return (this.fixA ? 0 : 1) + (this.fixB ? 0 : 1);
    }

    @Override
    public void setParameters(double[] pars, int off) {
        if (!this.fixA) {
            this.a = pars[off];
            ++off;
        }
        if (!this.fixB) {
            this.b = pars[off];
        }
    }

    @Override
    public double[] getCurrentParameterValues() {
        if (this.fixA && this.fixB) {
            return new double[0];
        }
        if (this.fixA) {
            return new double[]{this.b};
        }
        if (this.fixB) {
            return new double[]{this.a};
        }
        return new double[]{this.a, this.b};
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int off) {
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) {
        if (!this.fixA) {
            this.a = Math.log(0.5);
        }
        if (!this.fixB) {
            this.b = 5.0;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[" + this.a + "," + this.b + "]\n");
        int i = 0;
        while (i < 20) {
            buf.append(String.valueOf(Math.exp(this.getLogScore(i))) + ", ");
            ++i;
        }
        return buf.toString();
    }
}

