/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable;

import de.jstacs.NotTrainedException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.differentiable.UniformDiffSS;
import de.jstacs.sequenceScores.statisticalModels.differentiable.SamplingDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;

public class UniformDiffSM
extends UniformDiffSS
implements SamplingDifferentiableStatisticalModel {
    private double ess;
    private double logP;

    public UniformDiffSM(AlphabetContainer alphabets, int length, double ess) {
        super(alphabets, length);
        if (!alphabets.isDiscrete()) {
            throw new IllegalArgumentException("The given AlphabetContainer has to be discrete.");
        }
        if (ess < 0.0) {
            throw new IllegalArgumentException("The given ess has to be non-negative.");
        }
        this.ess = ess;
        this.computeLogP();
    }

    public UniformDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.computeLogP();
    }

    private void computeLogP() {
        this.logP = 1.0;
        int i = 0;
        while (i < this.length) {
            this.logP *= this.alphabets.getAlphabetLengthAt(i);
            ++i;
        }
        this.logP = -Math.log(this.logP);
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        return this.logP;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList dList) {
        return this.logP;
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer b = new StringBuffer(1000);
        XMLParser.appendObjectWithTags(b, this.ess, "ess");
        return b;
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        try {
            this.ess = XMLParser.extractObjectForTags(xml, "ess", Double.TYPE);
        }
        catch (NonParsableException n) {
            this.ess = 0.0;
        }
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public void initializeFunction(int index, boolean meila, DataSet[] data, double[][] weights) {
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        throw new IndexOutOfBoundsException("Since a uniform scoring function has no parameters, this method can not be used");
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer info = new StringBuffer(this.length * 100);
        int j = 0;
        while (j < this.length) {
            double val = 1.0 / this.alphabets.getAlphabetLengthAt(0);
            info.append(String.valueOf(j) + "\t" + nf.format(val) + " for each element of " + this.alphabets.getAlphabetAt(j).toString());
            if (j < this.length - 1) {
                info.append("\n");
            }
            ++j;
        }
        return info.toString();
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public int[][] getSamplingGroups(int parameterOffset) {
        return new int[0][];
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos) throws Exception {
        return this.getLogScoreFor(sequence, startpos) - this.getLogNormalizationConstant();
    }

    @Override
    public double getLogProbFor(Sequence sequence) throws Exception {
        return this.getLogScoreFor(sequence) - this.getLogNormalizationConstant();
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        if (endpos - startpos + 1 != this.length) {
            throw new IllegalArgumentException();
        }
        return this.getLogProbFor(sequence, startpos);
    }

    @Override
    public DataSet emitDataSet(int numberOfSequences, int ... seqLength) throws NotTrainedException, Exception {
        throw new Exception("Standard implementation of emitDataSet used for " + this.getInstanceName() + ". You have to overwrite this method to use it in a proper way.");
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The maximal markov order for this model in undefined.");
    }
}

