 # Import FPDF class
from fpdf import FPDF

 # Import glob module to find all the files matching a pattern
import glob

#############################################################################################################################################################3

def pdf_after_DE(analysis,top,font_path,iso_star_fl,non_star_fl):

  # Image extensions
  if analysis=="2":
     image_extensions = ("tem.png","a2.png","non.png")
  else:
    image_extensions = ("tem.png","a2.png")
 
  # This list will hold the images file names
  images = []

  # Build the image list by merging the glob results (a list of files)
  # for each extension. We are taking images from current folder.
  for extension in image_extensions:
      images.extend(glob.glob(extension))
 
  # Create instance of FPDF class
  pdf = FPDF('P', 'in', 'letter')
  pdf.add_font('uni-arial', '', font_path+"/arial-unicode-ms.ttf", uni=True)
  # Add new page. Without this you cannot create the document.
  pdf.add_page()
  # Set font to Arial, 'B'old, 16 pts
  pdf.set_font('Arial', 'B', 16.0)

  # Page header
  pdf.cell(pdf.w-0.5, 0.5, 'Differential expression of miRNAs and isomiRs',align='C')
  #pdf.ln(0.25)

  pdf.ln(0.7)
  pdf.set_font('Arial','B', 12.0)
  if "tem.png" in images:
     pdf.cell(pdf.w-0.5, 0.5, 'Top '+top+' differentially expressed miRNA and templated isoforms',align='C')
     # Smaller font for image captions
     pdf.set_font('Arial', '', 10.0)
     # Image caption 
     pdf.ln(0.4)
     pdf.image(images[images.index("tem.png")],x=0.8, w=7, h=8)
     pdf.ln(0.3)
     if iso_star_fl==1:
        pdf.set_font('uni-arial', '', 9.0)
        pdf.cell(0.2)
        pdf.cell(3.0, 0.0, "  ★ IsomiRs potentially generated from multiple loci")
        #pdf.set_font('Arial','B', 12.0)
  else:
     print("WARNING: There aren't miRNAs which fullfiled these criteria" )
  pdf.set_font('Arial','B', 12.0)
  if "non.png" in images and analysis=="2":
     if "tem.png" in images: pdf.add_page()
     pdf.ln(0.7)
     pdf.cell(pdf.w-0.5, 0.5, 'Top '+top+' differentially expressed non-templated isomiRs',align='C')
     pdf.ln(0.4)
     pdf.image(images[images.index("non.png")],x=0.8, w=7, h=8)
     pdf.ln(0.3)
     if  non_star_fl==1:
         pdf.set_font('uni-arial', '', 9.0)
         pdf.cell(0.2)
         pdf.cell(3.0, 0.0, "  ★ IsomiRs potentially generated from multiple loci")

     #pdf.image(images[images.index("non.png")],x=0.5, w=7.5, h=6.5)
  else:
     print("WARNING: There aren't non-template miRNAs which fullfiled these criteria" )

  pdf.set_font('Arial','B', 12.0)
  if "a2.png" in images:
     if len(images)>=2: pdf.add_page()
     pdf.ln(0.5)
     pdf.cell(pdf.w-0.5, 0.5, 'Top differentially expressed miRNAs and isomiRs grouped by arm',align='C')
     pdf.ln(0.4)
     pdf.image(images[images.index("a2.png")],x=0.8, w=7, h=8)
     pdf.ln(0.3)
  else:
     print("WARNING: There aren't non-template miRNAs which fullfiled these criteria" )


  pdf.output('report2.pdf', 'F')



