/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLIndividualImpl
extends OWLObjectImpl
implements OWLIndividual {
    protected OWLIndividualImpl(OWLDataFactory dataFactory) {
        super(dataFactory);
    }

    public boolean isBuiltIn() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof OWLIndividual;
    }

    @Override
    public Set<OWLClassExpression> getTypes(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLClassAssertionAxiom axiom : ontology.getClassAssertionAxioms(this)) {
            result.add(axiom.getClassExpression());
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getTypes(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getTypes(ont));
        }
        return result;
    }

    public Map<OWLProperty, Set<OWLObject>> getPropertyValues(OWLOntology ontology) {
        HashMap<OWLProperty, Set<OWLObject>> results = new HashMap<OWLProperty, Set<OWLObject>>();
        Map<OWLObjectPropertyExpression, Set<OWLIndividual>> opMap = this.getObjectPropertyValues(ontology);
        for (OWLObjectPropertyExpression prop : opMap.keySet()) {
            results.put((OWLProperty)((Object)prop), new HashSet(opMap.get(prop)));
        }
        Map<OWLDataPropertyExpression, Set<OWLLiteral>> dpMap = this.getDataPropertyValues(ontology);
        for (OWLDataPropertyExpression prop : dpMap.keySet()) {
            results.put((OWLProperty)((Object)prop), new HashSet(dpMap.get(prop)));
        }
        return results;
    }

    @Override
    public Set<OWLIndividual> getObjectPropertyValues(OWLObjectPropertyExpression property, OWLOntology ontology) {
        Map<OWLObjectPropertyExpression, Set<OWLIndividual>> map = this.getObjectPropertyValues(ontology);
        Set<OWLIndividual> vals = map.get(property);
        if (vals == null) {
            return Collections.emptySet();
        }
        return new HashSet<OWLIndividual>(vals);
    }

    public Map<OWLProperty, Set<OWLObject>> getNPropertyValues(OWLOntology ontology) {
        HashMap<OWLProperty, Set<OWLObject>> results = new HashMap<OWLProperty, Set<OWLObject>>();
        Map<OWLObjectPropertyExpression, Set<OWLIndividual>> opMap = this.getObjectPropertyValues(ontology);
        for (OWLObjectPropertyExpression prop : opMap.keySet()) {
            results.put((OWLProperty)((Object)prop), new HashSet(opMap.get(prop)));
        }
        Map<OWLDataPropertyExpression, Set<OWLLiteral>> dpMap = this.getDataPropertyValues(ontology);
        for (OWLDataPropertyExpression prop : dpMap.keySet()) {
            results.put((OWLProperty)((Object)prop), new HashSet(dpMap.get(prop)));
        }
        return results;
    }

    @Override
    public Set<OWLLiteral> getDataPropertyValues(OWLDataPropertyExpression property, OWLOntology ontology) {
        HashSet<OWLLiteral> result = new HashSet<OWLLiteral>();
        for (OWLDataPropertyAssertionAxiom ax : ontology.getDataPropertyAssertionAxioms(this)) {
            if (!((OWLDataPropertyExpression)ax.getProperty()).equals(property)) continue;
            result.add((OWLLiteral)ax.getObject());
        }
        return result;
    }

    @Override
    public boolean hasObjectPropertyValue(OWLObjectPropertyExpression property, OWLIndividual individual, OWLOntology ontology) {
        for (OWLObjectPropertyAssertionAxiom ax : ontology.getObjectPropertyAssertionAxioms(this)) {
            if (!((OWLObjectPropertyExpression)ax.getProperty()).equals(property) || !((OWLIndividual)ax.getObject()).equals(individual)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<OWLObjectPropertyExpression, Set<OWLIndividual>> getObjectPropertyValues(OWLOntology ontology) {
        HashMap<OWLObjectPropertyExpression, Set<OWLIndividual>> result = new HashMap<OWLObjectPropertyExpression, Set<OWLIndividual>>();
        for (OWLObjectPropertyAssertionAxiom ax : ontology.getObjectPropertyAssertionAxioms(this)) {
            TreeSet inds = (TreeSet)result.get(ax.getProperty());
            if (inds == null) {
                inds = new TreeSet();
                result.put((OWLObjectPropertyExpression)ax.getProperty(), inds);
            }
            inds.add(ax.getObject());
        }
        return result;
    }

    @Override
    public Map<OWLObjectPropertyExpression, Set<OWLIndividual>> getNegativeObjectPropertyValues(OWLOntology ontology) {
        HashMap<OWLObjectPropertyExpression, Set<OWLIndividual>> result = new HashMap<OWLObjectPropertyExpression, Set<OWLIndividual>>();
        for (OWLNegativeObjectPropertyAssertionAxiom ax : ontology.getNegativeObjectPropertyAssertionAxioms(this)) {
            TreeSet inds = (TreeSet)result.get(ax.getProperty());
            if (inds == null) {
                inds = new TreeSet();
                result.put((OWLObjectPropertyExpression)ax.getProperty(), inds);
            }
            inds.add(ax.getObject());
        }
        return result;
    }

    @Override
    public boolean hasNegativeObjectPropertyValue(OWLObjectPropertyExpression property, OWLIndividual individual, OWLOntology ontology) {
        for (OWLNegativeObjectPropertyAssertionAxiom ax : ontology.getNegativeObjectPropertyAssertionAxioms(this)) {
            if (!((OWLObjectPropertyExpression)ax.getProperty()).equals(property) || !((OWLIndividual)ax.getObject()).equals(individual)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<OWLDataPropertyExpression, Set<OWLLiteral>> getDataPropertyValues(OWLOntology ontology) {
        HashMap<OWLDataPropertyExpression, Set<OWLLiteral>> result = new HashMap<OWLDataPropertyExpression, Set<OWLLiteral>>();
        for (OWLDataPropertyAssertionAxiom ax : ontology.getDataPropertyAssertionAxioms(this)) {
            TreeSet vals = (TreeSet)result.get(ax.getProperty());
            if (vals == null) {
                vals = new TreeSet();
                result.put((OWLDataPropertyExpression)ax.getProperty(), vals);
            }
            vals.add(ax.getObject());
        }
        return result;
    }

    @Override
    public Map<OWLDataPropertyExpression, Set<OWLLiteral>> getNegativeDataPropertyValues(OWLOntology ontology) {
        HashMap<OWLDataPropertyExpression, Set<OWLLiteral>> result = new HashMap<OWLDataPropertyExpression, Set<OWLLiteral>>();
        for (OWLNegativeDataPropertyAssertionAxiom ax : ontology.getNegativeDataPropertyAssertionAxioms(this)) {
            TreeSet inds = (TreeSet)result.get(ax.getProperty());
            if (inds == null) {
                inds = new TreeSet();
                result.put((OWLDataPropertyExpression)ax.getProperty(), inds);
            }
            inds.add(ax.getObject());
        }
        return result;
    }

    @Override
    public boolean hasNegativeDataPropertyValue(OWLDataPropertyExpression property, OWLLiteral literal, OWLOntology ontology) {
        for (OWLNegativeDataPropertyAssertionAxiom ax : ontology.getNegativeDataPropertyAssertionAxioms(this)) {
            if (!((OWLDataPropertyExpression)ax.getProperty()).equals(property) || !((OWLLiteral)ax.getObject()).equals(literal)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLClassAssertionAxiom> getIndividualTypeAxioms(OWLOntology ontology) {
        return ontology.getClassAssertionAxioms(this);
    }

    public Set<OWLObjectPropertyAssertionAxiom> getIndividualObjectRelationshipAxioms(OWLOntology ontology) {
        return ontology.getObjectPropertyAssertionAxioms(this);
    }

    public Set<OWLDataPropertyAssertionAxiom> getIndividualDataRelationshipAxioms(OWLOntology ontology) {
        return ontology.getDataPropertyAssertionAxioms(this);
    }

    @Override
    public Set<OWLIndividual> getSameIndividuals(OWLOntology ontology) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLSameIndividualAxiom ax : ontology.getSameIndividualAxioms(this)) {
            result.addAll(ax.getIndividuals());
        }
        result.remove(this);
        return result;
    }

    @Override
    public Set<OWLIndividual> getDifferentIndividuals(OWLOntology ontology) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLDifferentIndividualsAxiom ax : ontology.getDifferentIndividualAxioms(this)) {
            result.addAll(ax.getIndividuals());
        }
        result.remove(this);
        return result;
    }

    public Set<OWLNegativeObjectPropertyAssertionAxiom> getIndividualNotObjectRelationshipAxioms(OWLOntology ontology) throws OWLException {
        return ontology.getNegativeObjectPropertyAssertionAxioms(this);
    }

    public Set<OWLNegativeDataPropertyAssertionAxiom> getIndividualNotDataRelationshipAxioms(OWLOntology ontology) throws OWLException {
        return ontology.getNegativeDataPropertyAssertionAxioms(this);
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not an OWLClass!");
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a data type!");
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an object property");
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return false;
    }
}

