/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.structural;

import org.semanticweb.owlapi.apibinding.OWLFunctionalSyntaxFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ConsoleProgressMonitor;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.structural.StructuralReasoner;
import org.semanticweb.owlapi.util.DefaultPrefixManager;

public class TestStructuralReasoner {
    public static void main(String[] args) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            NullReasonerProgressMonitor progressMonitor = new NullReasonerProgressMonitor();
            OWLOntology ont = man.loadOntologyFromOntologyDocument(IRI.create("file:/Users/matthewhorridge/ontologies/badthesaurus/BadThesaurus.owl.zip"));
            System.out.println("Loaded: " + ont);
            SimpleConfiguration configuration = new SimpleConfiguration(new ConsoleProgressMonitor());
            StructuralReasoner reasoner = new StructuralReasoner(ont, configuration, BufferingMode.NON_BUFFERING);
            long t0 = System.currentTimeMillis();
            reasoner.prepareReasoner();
            long t1 = System.currentTimeMillis();
            System.out.println("Time to prepare reasoner: " + (t1 - t0));
            OWLDeclarationAxiom ax = OWLFunctionalSyntaxFactory.Declaration(OWLFunctionalSyntaxFactory.Class(IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl#X")));
            DefaultPrefixManager pm = new DefaultPrefixManager("http://www.co-ode.org/ontologies/pizza/pizza.owl#");
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            man.addAxiom(ont, ax);
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            man.addAxiom(ont, OWLFunctionalSyntaxFactory.SubClassOf(OWLFunctionalSyntaxFactory.Class("X", pm), OWLFunctionalSyntaxFactory.Class("Y", pm)));
            man.addAxiom(ont, OWLFunctionalSyntaxFactory.SubClassOf(OWLFunctionalSyntaxFactory.Class("Y", pm), OWLFunctionalSyntaxFactory.Class("X", pm)));
            man.addAxiom(ont, OWLFunctionalSyntaxFactory.SubClassOf(OWLFunctionalSyntaxFactory.Class("E", pm), OWLFunctionalSyntaxFactory.Class("F", pm)));
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }
}

