/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLProfileViolation {
    private OWLOntologyID ontologyID;
    private Map<OWLOntologyID, IRI> importsClosureMap = new HashMap<OWLOntologyID, IRI>();
    private OWLAxiom axiom;

    public OWLProfileViolation(OWLOntology ontology, OWLAxiom axiom) {
        this.axiom = axiom;
        this.ontologyID = ontology.getOntologyID();
        for (OWLOntology ont : ontology.getImportsClosure()) {
            this.importsClosureMap.put(ont.getOntologyID(), ont.getOWLOntologyManager().getOntologyDocumentIRI(ont));
        }
    }

    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public IRI getDocumentIRI(OWLOntologyID ontologyID) {
        return this.importsClosureMap.get(ontologyID);
    }

    public Set<OWLOntologyID> getImportsClosure() {
        return this.importsClosureMap.keySet();
    }
}

