/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Set;
import org.coode.owlapi.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TypeNegativePropertyAssertionHandler
extends BuiltInTypeHandler {
    public TypeNegativePropertyAssertionHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        OWLAnnotationValue target;
        IRI property;
        IRI source = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), true);
        if (source == null) {
            source = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_SUBJECT.getIRI(), true);
        }
        if (source == null) {
            source = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDF_SUBJECT.getIRI(), true);
        }
        if ((property = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), true)) == null) {
            property = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_PREDICATE.getIRI(), true);
        }
        if (property == null) {
            property = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDF_PREDICATE.getIRI(), true);
        }
        if ((target = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getIRI(), true)) == null) {
            target = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_OBJECT.getIRI(), true);
        }
        if (target == null) {
            target = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDF_OBJECT.getIRI(), true);
        }
        if (target == null) {
            target = this.getConsumer().getLiteralObject(subject, OWLRDFVocabulary.OWL_OBJECT.getIRI(), true);
        }
        if (target == null) {
            target = this.getConsumer().getLiteralObject(subject, OWLRDFVocabulary.RDF_OBJECT.getIRI(), true);
        }
        if (target == null) {
            target = this.getConsumer().getLiteralObject(subject, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), true);
        }
        Set<OWLAnnotation> annos = this.getConsumer().translateAnnotations(subject);
        if (target instanceof OWLLiteral) {
            OWLIndividual sourceInd = this.getConsumer().getOWLIndividual(source);
            OWLDataPropertyExpression prop = this.getConsumer().translateDataPropertyExpression(property);
            OWLLiteral lit = (OWLLiteral)target;
            this.consumeTriple(subject, predicate, object);
            this.addAxiom(this.getDataFactory().getOWLNegativeDataPropertyAssertionAxiom(prop, sourceInd, lit, annos));
        } else {
            OWLIndividual sourceInd = this.getConsumer().getOWLIndividual(source);
            OWLObjectPropertyExpression prop = this.getConsumer().translateObjectPropertyExpression(property);
            OWLIndividual targetInd = this.getConsumer().getOWLIndividual((IRI)target);
            this.consumeTriple(subject, predicate, object);
            this.addAxiom(this.getDataFactory().getOWLNegativeObjectPropertyAssertionAxiom(prop, sourceInd, targetInd, annos));
        }
    }
}

