/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.modularity;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.modularity.OntologySegmenter;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticLocalityModuleExtractor
implements OntologySegmenter {
    protected ModuleType moduleType;
    protected OntologyAxiomSet ontologyAxiomSet;
    protected OWLOntology ontology;
    protected OWLOntologyManager manager;

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, OWLOntology ont, Set<OWLAxiom> axs, ModuleType moduleType) {
        this.setModuleType(moduleType);
        this.manager = man;
        this.ontology = ont;
        this.ontologyAxiomSet = new OntologyAxiomSet(axs);
    }

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, OWLOntology ont, ModuleType moduleType) {
        this(man, ont, ont.getAxioms(), moduleType);
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    protected boolean[] extractLogicalAxioms(boolean[] subOnt, Set<OWLEntity> signature, LocalityClass localityClass, boolean verbose) {
        boolean[] mod = this.ontologyAxiomSet.getSubset(false);
        boolean[] q2 = this.ontologyAxiomSet.cloneSubset(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        int loopNumber = 0;
        while (change) {
            change = false;
            ++loopNumber;
            if (verbose) {
                System.out.println("  Loop " + loopNumber);
            }
            for (int i = 0; i < q2.length; ++i) {
                if (!q2[i]) continue;
                if (!sle.isLocal(this.ontologyAxiomSet.getAxiom(i), signature)) {
                    if (verbose) {
                        System.out.println("      Non-local axiom:   " + this.ontologyAxiomSet.getAxiom(i));
                    }
                    mod[i] = true;
                    q2[i] = false;
                    int oldSize = signature.size();
                    signature.addAll(this.ontologyAxiomSet.getAxiom(i).getSignature());
                    if (signature.size() <= oldSize) continue;
                    change = true;
                    if (!verbose) continue;
                    System.out.print("    New signature:   ");
                    for (OWLEntity ent : signature) {
                        System.out.print(ent + ", ");
                    }
                    System.out.println();
                    continue;
                }
                if (!verbose) continue;
                System.out.println("      Local axiom:       " + this.ontologyAxiomSet.getAxiom(i));
            }
        }
        return mod;
    }

    protected Set<OWLAxiom> extract(Set<OWLAxiom> subOnt, Set<OWLEntity> signature, LocalityClass localityClass, boolean verbose) {
        HashSet<OWLAxiom> mod = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> q2 = new HashSet<OWLAxiom>(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        int loopNumber = 0;
        while (change) {
            change = false;
            ++loopNumber;
            if (verbose) {
                System.out.println("  Loop " + loopNumber);
            }
            HashSet<OWLAxiom> q2remove = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : q2) {
                if (!sle.isLocal(ax, signature)) {
                    if (verbose) {
                        System.out.println("      Non-local axiom:   " + ax);
                    }
                    mod.add(ax);
                    q2remove.add(ax);
                    int oldSize = signature.size();
                    signature.addAll(ax.getSignature());
                    if (signature.size() <= oldSize) continue;
                    change = true;
                    if (!verbose) continue;
                    System.out.print("    New signature:   ");
                    for (OWLEntity ent : signature) {
                        System.out.print(ent + ", ");
                    }
                    System.out.println();
                    continue;
                }
                if (!verbose) continue;
                System.out.println("      Local axiom:       " + ax);
            }
            q2.removeAll(q2remove);
        }
        return mod;
    }

    protected Set<OWLAxiom> enrich(Set<OWLAxiom> module, Set<OWLEntity> sig, boolean verbose) {
        HashSet<OWLAxiom> enrichedModule = new HashSet<OWLAxiom>(module);
        if (verbose) {
            System.out.println("\nEnriching with declaration axioms ...");
        }
        if (this.ontology != null) {
            for (OWLEntity entity : sig) {
                Set<OWLDeclarationAxiom> declarationAxioms = this.ontology.getDeclarationAxioms(entity);
                enrichedModule.addAll(declarationAxioms);
                if (verbose) {
                    for (OWLDeclarationAxiom declarationAxiom : declarationAxioms) {
                        System.out.println("  Added entity declaration axiom:   " + declarationAxiom);
                    }
                }
                Set<OWLAnnotationAssertionAxiom> entityAnnotationAxioms = entity.getAnnotationAssertionAxioms(this.ontology);
                enrichedModule.addAll(entityAnnotationAxioms);
                if (!verbose) continue;
                for (OWLAnnotationAssertionAxiom entityAnnotationAxiom : entityAnnotationAxioms) {
                    System.out.println("  Added entity annotation axiom:   " + entityAnnotationAxiom);
                }
            }
        }
        return enrichedModule;
    }

    protected Set<OWLAxiom> extractUnnestedModule(Set<OWLEntity> sig, LocalityClass cls, boolean verbose) {
        if (verbose) {
            System.out.print("\nExtracting " + (Object)((Object)cls) + " module ... ");
            for (OWLEntity ent : sig) {
                System.out.print(ent + ", ");
            }
            System.out.println();
        }
        boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>(sig);
        boolean[] module = this.extractLogicalAxioms(subOnt, signature, cls, verbose);
        Set<OWLAxiom> moduleAsSet = this.ontologyAxiomSet.toSet(module);
        return this.enrich(moduleAsSet, signature, verbose);
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> sig) {
        return this.extract(sig, false);
    }

    protected Set<OWLAxiom> extract(Set<OWLEntity> sig, boolean verbose) {
        switch (this.moduleType) {
            case TOP: {
                return this.extractUnnestedModule(sig, LocalityClass.TOP_TOP, verbose);
            }
            case BOT: {
                return this.extractUnnestedModule(sig, LocalityClass.BOTTOM_BOTTOM, verbose);
            }
            case STAR: {
                boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
                boolean nextStepNecessary = true;
                boolean inFirstStep = true;
                LocalityClass localityClass = LocalityClass.BOTTOM_BOTTOM;
                HashSet<OWLEntity> seedSig = new HashSet<OWLEntity>(sig);
                while (nextStepNecessary) {
                    if (verbose) {
                        System.out.print("\nExtracting " + (Object)((Object)localityClass) + " module ... ");
                        for (OWLEntity ent : sig) {
                            System.out.print(ent + ", ");
                        }
                        System.out.println();
                    }
                    int previousModuleSize = this.ontologyAxiomSet.subsetCardinality(subOnt);
                    seedSig = new HashSet<OWLEntity>(sig);
                    if (this.ontologyAxiomSet.subsetCardinality(subOnt = this.extractLogicalAxioms(subOnt, seedSig, localityClass, verbose)) == previousModuleSize && !inFirstStep) {
                        nextStepNecessary = false;
                    }
                    inFirstStep = false;
                    if (localityClass == LocalityClass.BOTTOM_BOTTOM) {
                        localityClass = LocalityClass.TOP_TOP;
                        continue;
                    }
                    localityClass = LocalityClass.BOTTOM_BOTTOM;
                }
                Set<OWLAxiom> moduleAsSet = this.ontologyAxiomSet.toSet(subOnt);
                return this.enrich(moduleAsSet, seedSig, verbose);
            }
        }
        throw new RuntimeException("Unsupported module type: " + (Object)((Object)this.moduleType));
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri) throws OWLOntologyCreationException {
        return this.extractAsOntology(signature, iri, false);
    }

    protected OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri, boolean verbose) throws OWLOntologyCreationException {
        Set<OWLAxiom> axs = this.extract(signature, verbose);
        OWLOntology newOnt = this.manager.createOntology(iri);
        LinkedList<AddAxiom> addaxs = new LinkedList<AddAxiom>();
        for (OWLAxiom ax : axs) {
            addaxs.add(new AddAxiom(newOnt, ax));
        }
        this.manager.applyChanges(addaxs);
        return newOnt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OntologyAxiomSet {
        protected OWLAxiom[] ax;

        public OntologyAxiomSet(Set<OWLAxiom> axs) {
            this.ax = axs.toArray(new OWLAxiom[axs.size()]);
        }

        public int size() {
            return this.ax.length;
        }

        public OWLAxiom getAxiom(int i) {
            return this.ax[i];
        }

        public OWLAxiom[] getAllAxioms() {
            return this.ax;
        }

        public Set<OWLAxiom> getAxiomSet(boolean[] isIn) {
            HashSet<OWLAxiom> gas = new HashSet<OWLAxiom>();
            for (int i = 0; i < isIn.length; ++i) {
                if (!isIn[i]) continue;
                gas.add(this.ax[i]);
            }
            return gas;
        }

        public boolean[] getSubset(boolean init) {
            boolean[] subset = new boolean[this.ax.length];
            for (int i = 0; i < this.ax.length; ++i) {
                subset[i] = init;
            }
            return subset;
        }

        public boolean[] cloneSubset(boolean[] oldSubset) {
            boolean[] newSubset = new boolean[this.ax.length];
            System.arraycopy(oldSubset, 0, newSubset, 0, this.ax.length);
            return newSubset;
        }

        public int subsetCardinality(boolean[] subset) {
            int card = 0;
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                ++card;
            }
            return card;
        }

        public Set<OWLAxiom> toSet(boolean[] subset) {
            HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>();
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                axs.add(this.ax[i]);
            }
            return axs;
        }
    }
}

