/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OWLOntologyAlreadyExistsException
extends OWLOntologyCreationException {
    private OWLOntologyID ontologyID;
    private IRI documentIRI;

    public OWLOntologyAlreadyExistsException(OWLOntologyID id) {
        super("Ontology already exists. " + id);
        this.ontologyID = id;
    }

    public OWLOntologyAlreadyExistsException(OWLOntologyID ontologyID, IRI documentIRI) {
        super("Ontology already exists. " + ontologyID + " (New ontology loaded from " + documentIRI.toQuotedString() + ")");
        this.ontologyID = ontologyID;
        this.documentIRI = documentIRI;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }
}

