/*
 * (c) Copyright IBM Corp 2001, 2005 
 */

package javax.wadls.extensions;

import org.w3c.dom.*;

import javax.wadls.*;
import javax.xml.namespace.*;

import edu.uga.cs.lsdis.meteors.wadls.*;
import edu.uga.cs.lsdis.meteors.wadls.util.xml.*;

/**
 * This class is used to deserialize arbitrary elements into
 * UnknownExtensibilityElement instances.
 *
 * @see UnknownExtensibilityElement
 * @see UnknownExtensionSerializer
 *
 * @author Matthew J. Duftler (duftler@us.ibm.com)
 */
public class UnknownExtensionDeserializer implements ExtensionDeserializer,
                                                     java.io.Serializable
{
  public static final long serialVersionUID = 1;

  public ExtensibilityElement unmarshall(Class parentType,
                                         QName elementType,
                                         Element el,
                                         Application app,
                                         ExtensionRegistry extReg)
                                           throws WADLSException
  {
	  System.out.println("%%%% Inside UnMarshall for Element:"+el.getNodeName());
    UnknownExtensibilityElement unknownExt = new UnknownExtensibilityElement();
    String requiredStr = DOMUtils.getAttributeNS(el,
                                                 Constants.NS_URI_WADL,
                                                 Constants.ATTR_REQUIRED);

    System.out.println("%%%% Required Str:"+requiredStr);
    System.out.println("%%%% Element Type To String:"+elementType.toString());
    unknownExt.setElementType(elementType);

    if (requiredStr != null)
    {
      unknownExt.setRequired(new Boolean(requiredStr));
    }

    unknownExt.setElement(el);

    return unknownExt;
  }
}