package javax.wadls;

import org.w3c.dom.*;


/**
 * This interface represents an effect.
 *
 * @author Zixin Wu
 */
public interface Effect extends java.io.Serializable, ModelReferenceExtensible
{
	/**
	 * Set the name of this effect.
	 *
	 * @param name the desired name
	 */
	public void setName(String name);
	
	/**
	 * Get the name of this effect.
	 *
	 * @return the effect name
	 */
	public String getName();
	
	/**
	 * Set the expression of this effect.
	 *
	 * @param expression The desired expression.
	 */
	public void setExpression(String expression);
	
	/**
	 * Get the expression of this effect.
	 *
	 * @return The expression.
	 */
	public String getExpression();
	
	/**
	 * Set the documentation element for this document. This dependency
	 * on org.w3c.dom.Element should eventually be removed when a more
	 * appropriate way of representing this information is employed.
	 *
	 * @param docEl the documentation element
	 */
	public void setDocumentationElement(Element docEl);
	
	/**
	 * Get the documentation element. This dependency on org.w3c.dom.Element
	 * should eventually be removed when a more appropriate way of
	 * representing this information is employed.
	 *
	 * @return the documentation element
	 */
	public Element getDocumentationElement();
	
}
