/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.xpointer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.woden.types.NCName;
import org.apache.woden.xpointer.InvalidXPointerException;
import org.apache.woden.xpointer.PointerPart;

public class ElementPointerPart
implements PointerPart {
    private final NCName ncname;
    private final List childSequence;

    public ElementPointerPart(NCName elementID) {
        if (elementID == null) {
            throw new NullPointerException("The elementID argument is null.");
        }
        this.ncname = elementID;
        this.childSequence = null;
    }

    public ElementPointerPart(List childSequence) {
        if (childSequence == null) {
            throw new NullPointerException("The childSequence argument is null.");
        }
        if (childSequence.isEmpty()) {
            throw new IllegalArgumentException("The childSequence list is empty.");
        }
        Iterator it = childSequence.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof Integer) continue;
            throw new IllegalArgumentException("The childSequence list must only contain Integers.");
        }
        this.ncname = null;
        this.childSequence = childSequence;
    }

    public ElementPointerPart(NCName elementID, List childSequence) {
        if (elementID == null) {
            throw new NullPointerException("The elementID argument is null.");
        }
        if (childSequence == null) {
            throw new NullPointerException("The childSequence argument is null.");
        }
        if (childSequence.isEmpty()) {
            throw new IllegalArgumentException("The childSequence list is empty.");
        }
        Iterator it = childSequence.iterator();
        while (it.hasNext()) {
            Object integer = it.next();
            if (!(integer instanceof Integer)) {
                throw new IllegalArgumentException("the childSequence list must only contain Integers.");
            }
            if ((Integer)integer != 0) continue;
            throw new IllegalArgumentException("the childSequence list must only contain Integers bigger than 0.");
        }
        this.ncname = elementID;
        this.childSequence = childSequence;
    }

    public NCName getNCName() {
        return this.ncname;
    }

    public Integer[] getChildSequence() {
        int size = this.childSequence.size();
        Integer[] sequence = new Integer[size];
        for (int i = 0; i < size; ++i) {
            sequence[i] = (Integer)this.childSequence.get(i);
        }
        return sequence;
    }

    public boolean hasNCName() {
        return this.ncname != null;
    }

    public boolean hasChildSequence() {
        return this.childSequence != null;
    }

    public String toString() {
        String schemeData = this.childSequence == null ? this.ncname.toString() : (this.ncname == null ? this.serialiseChildSequence() : this.ncname.toString() + this.serialiseChildSequence());
        return "element(" + schemeData + ")";
    }

    private String serialiseChildSequence() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.childSequence.iterator();
        while (it.hasNext()) {
            Integer child = (Integer)it.next();
            buffer.append("/" + child.toString());
        }
        return buffer.toString();
    }

    public static ElementPointerPart parseFromString(String schemeData) throws InvalidXPointerException {
        ArrayList<Integer> childSequence = null;
        NCName elementID = null;
        int startChar = schemeData.indexOf("/");
        switch (startChar) {
            case -1: {
                try {
                    elementID = new NCName(schemeData);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidXPointerException("Invalid NCName in the XPointer", schemeData);
                }
                return new ElementPointerPart(elementID);
            }
            case 0: {
                break;
            }
            default: {
                try {
                    elementID = new NCName(schemeData.substring(0, startChar));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidXPointerException("Invalid NCName in the XPointer", schemeData, 0, startChar);
                }
            }
        }
        childSequence = new ArrayList<Integer>();
        int endChar = schemeData.indexOf("/", startChar + 1);
        if (endChar < 0) {
            childSequence.add(ElementPointerPart.parseIntegerFromChildSequence(schemeData, startChar + 1, schemeData.length()));
        } else {
            while (true) {
                if (endChar < 0) {
                    childSequence.add(ElementPointerPart.parseIntegerFromChildSequence(schemeData, startChar + 1, schemeData.length()));
                    break;
                }
                childSequence.add(ElementPointerPart.parseIntegerFromChildSequence(schemeData, startChar + 1, endChar));
                startChar = endChar;
                endChar = schemeData.indexOf("/", startChar + 1);
            }
        }
        if (elementID == null) {
            return new ElementPointerPart(childSequence);
        }
        return new ElementPointerPart(elementID, childSequence);
    }

    private static Integer parseIntegerFromChildSequence(String string, int start, int end) throws InvalidXPointerException {
        if (start < end) {
            try {
                return new Integer(string.substring(start, end));
            }
            catch (NumberFormatException e) {
                throw new InvalidXPointerException("The child sequence part contained a invalid integer.", string, start, end);
            }
        }
        throw new InvalidXPointerException("The child sequence part contained a empty item at " + String.valueOf(start), string, start, end);
    }
}

