/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.functionalrenderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.coode.owlapi.functionalrenderer.OWLObjectRenderer;
import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class OWLFunctionalSyntaxOntologyStorer
extends AbstractOWLOntologyStorer {
    public boolean canStoreOntology(OWLOntologyFormat ontologyFormat) {
        return ontologyFormat.equals(new OWLFunctionalSyntaxOntologyFormat());
    }

    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer writer, OWLOntologyFormat format) throws OWLOntologyStorageException {
        try {
            OWLObjectRenderer ren = new OWLObjectRenderer(manager, ontology, writer);
            if (format instanceof PrefixOWLOntologyFormat) {
                PrefixOWLOntologyFormat prefixFormat = (PrefixOWLOntologyFormat)format;
                DefaultPrefixManager man = new DefaultPrefixManager();
                Map<String, String> map = prefixFormat.getPrefixName2PrefixMap();
                for (String pn : map.keySet()) {
                    prefixFormat.setPrefix(pn, map.get(pn));
                }
                ren.setPrefixManager(man);
            }
            ontology.accept(ren);
            writer.flush();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }
}

