/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityRenamer {
    private OWLOntologyManager owlOntologyManager;
    private Set<OWLOntology> ontologies;

    public OWLEntityRenamer(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies) {
        this.owlOntologyManager = owlOntologyManager;
        this.ontologies = ontologies;
    }

    public List<OWLOntologyChange> changeIRI(IRI uri, IRI newIRI) {
        HashMap<IRI, IRI> uriMap = new HashMap<IRI, IRI>();
        uriMap.put(uri, newIRI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            OWLObjectDuplicator dup = new OWLObjectDuplicator(this.owlOntologyManager.getOWLDataFactory(), uriMap);
            OWLEntityRenamer.fillListWithTransformChanges(changes, this.getAxioms(ont, uri), ont, dup);
        }
        return changes;
    }

    public List<OWLOntologyChange> changeIRI(OWLEntity entity, IRI newIRI) {
        HashMap<OWLEntity, IRI> iriMap = new HashMap<OWLEntity, IRI>();
        iriMap.put(entity, newIRI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            OWLObjectDuplicator duplicator = new OWLObjectDuplicator(iriMap, this.owlOntologyManager.getOWLDataFactory());
            OWLEntityRenamer.fillListWithTransformChanges(changes, OWLEntityRenamer.getAxioms(ont, entity), ont, duplicator);
        }
        return changes;
    }

    public List<OWLOntologyChange> changeIRI(Map<OWLEntity, IRI> entity2IRIMap) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLEntity ent : entity2IRIMap.keySet()) {
                OWLObjectDuplicator duplicator = new OWLObjectDuplicator(entity2IRIMap, this.owlOntologyManager.getOWLDataFactory());
                OWLEntityRenamer.fillListWithTransformChanges(changes, OWLEntityRenamer.getAxioms(ont, ent), ont, duplicator);
            }
        }
        return changes;
    }

    private static Set<OWLAxiom> getAxioms(OWLOntology ont, OWLEntity entity) {
        Set<OWLAxiom> axioms = ont.getReferencingAxioms(entity);
        axioms.addAll(ont.getDeclarationAxioms(entity));
        axioms.addAll(ont.getAnnotationAssertionAxioms(entity.getIRI()));
        return axioms;
    }

    private Set<OWLAxiom> getAxioms(OWLOntology ont, IRI iri) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLClass(iri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLObjectProperty(iri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLDataProperty(iri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLNamedIndividual(iri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLDatatype(iri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLAnnotationProperty(iri)));
        axioms.addAll(ont.getAnnotationAssertionAxioms(iri));
        return axioms;
    }

    private static void fillListWithTransformChanges(List<OWLOntologyChange> changes, Set<OWLAxiom> axioms, OWLOntology ont, OWLObjectDuplicator duplicator) {
        for (OWLAxiom ax : axioms) {
            changes.add(new RemoveAxiom(ont, ax));
            OWLAxiom dupAx = (OWLAxiom)duplicator.duplicateObject(ax);
            changes.add(new AddAxiom(ont, dupAx));
        }
    }
}

