/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DublinCoreVocabulary {
    CONTRIBUTOR("contributor"),
    COVERAGE("coverage"),
    CREATOR("creator"),
    DATE("date"),
    DESCRIPTION("description"),
    FORMAT("format"),
    IDENTIFIER("identifier"),
    LANGUAGE("language"),
    PUBLISHER("publisher"),
    RELATION("relation"),
    RIGHTS("rights"),
    SOURCE("source"),
    SUBJECT("subject"),
    TITLE("title"),
    TYPE("type");

    private String shortName;
    private String qname;
    private IRI iri;
    public static final String NAME_SPACE = "http://purl.org/dc/elements/1.1/";
    public static final Set<URI> ALL_URIS;

    private DublinCoreVocabulary(String name) {
        this.shortName = name;
        this.qname = "dc:" + name;
        this.iri = IRI.create(NAME_SPACE + name);
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getQName() {
        return this.qname;
    }

    public URI getURI() {
        return this.iri.toURI();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public String toString() {
        return this.iri.toString();
    }

    static {
        ALL_URIS = new HashSet<URI>();
        for (DublinCoreVocabulary v : DublinCoreVocabulary.values()) {
            ALL_URIS.add(v.getURI());
        }
    }
}

