/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPPropertyRangeHandler
extends TriplePredicateHandler {
    private static final Logger logger = Logger.getLogger(TPPropertyRangeHandler.class.getName());

    public TPPropertyRangeHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_RANGE.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        if (!this.isAnonymous(object)) {
            if (this.getConsumer().isObjectPropertyOnly(subject)) {
                return true;
            }
            if (this.getConsumer().isDataPropertyOnly(subject)) {
                return true;
            }
        }
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isObjectPropertyOnly(subject)) {
            this.translateObjectPropertyRange(subject, object, predicate);
        } else if (this.getConsumer().isDataPropertyOnly(subject)) {
            this.addAxiom(this.getDataFactory().getOWLDataPropertyRangeAxiom(this.translateDataProperty(subject), this.translateDataRange(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isAnnotationProperty(subject)) {
            OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(subject);
            this.addAxiom(this.getDataFactory().getOWLAnnotationPropertyRangeAxiom(prop, object, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isDataRange(object)) {
            logger.fine("Assuming data property because range appears to be datatype: " + subject + " -> " + predicate + " -> " + object);
            this.addAxiom(this.getDataFactory().getOWLDataPropertyRangeAxiom(this.translateDataProperty(subject), this.translateDataRange(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isClass(object)) {
            logger.fine("Assuming object property because range appears to be a class: " + subject + " -> " + predicate + " -> " + object);
            this.translateObjectPropertyRange(subject, object, predicate);
        } else {
            logger.fine("Unable to determine range type.  Assuming object property: " + subject + " -> " + predicate + " -> " + object);
            this.translateObjectPropertyRange(subject, object, predicate);
        }
    }

    private void translateObjectPropertyRange(IRI subject, IRI object, IRI predicate) throws OWLOntologyChangeException {
        this.addAxiom(this.getDataFactory().getOWLObjectPropertyRangeAxiom(this.translateObjectProperty(subject), this.translateClassExpression(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

