/*
 * (c) Copyright IBM Corp 2001, 2005 
 */

package edu.uga.cs.lsdis.meteors.wadls.factory;

import javax.wadls.*;
import javax.wadls.extensions.*;
import javax.wadls.factory.*;
import javax.wadls.xml.*;

import edu.uga.cs.lsdis.meteors.wadls.*;
import edu.uga.cs.lsdis.meteors.wadls.xml.*;

/**
 * This class is a concrete implementation of the abstract class
 * WSDLFactory. Some ideas used here have been shamelessly
 * copied from the wonderful JAXP and Xerces work.
 *
 * @author Matthew J. Duftler (duftler@us.ibm.com)
 */
public class WADLFactoryImpl extends WADLFactory
{
  /**
   * Create a new instance of a Definition, with an instance
   * of a PopulatedExtensionRegistry as its ExtensionRegistry.
   *
   * @see edu.uga.cs.lsdis.meteors.wadls.extensions.PopulatedExtensionRegistry
   */
  public Application newApplication()
  {
    Application app = new ApplicationImpl();
    return app;
  }

  /**
   * Create a new instance of a WSDLReader.
   */
  public WADLReader newWADLReader()
  {
    return new WADLReaderImpl();
  }

  /**
   * Create a new instance of a WSDLWriter.
   */
  public WADLWriter newWADLWriter()
  {
    return new WADLWriterImpl();
  }

}