/*
 * (c) Copyright IBM Corp 2001, 2005 
 */

package edu.uga.cs.lsdis.meteors.wadls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wadls.Effect;
import javax.wadls.Request;
import javax.wadls.ModelReference;
import javax.wadls.Method;
import javax.wadls.Response;
import javax.wadls.PreCondition;
import org.w3c.dom.Element;

/**
 * This class represents a WSDL operation.
 * It includes information on input, output and fault
 * messages associated with usage of the operation.
 *
 * @author Zixin Wu (wuzixin@uga.edu)
 * @author Paul Fremantle (pzf@us.ibm.com)
 * @author Nirmal Mukhi (nmukhi@us.ibm.com)
 * @author Matthew J. Duftler (duftler@us.ibm.com)
 */
public class MethodImpl implements Method
{
	protected String name = null;
	protected Request request = null;
	protected Response response = null;
	protected List<ModelReference> modelRefs = null;
	protected PreCondition preCondition = null;
	protected Effect effect = null;
	protected List parameterOrder = null;
	protected Element docEl = null;
	protected List extElements = new Vector();
	protected boolean isUndefined = true;
	
	public static final long serialVersionUID = 1;
	

	public void addModelReference (ModelReference modelReference){
		if (this.modelRefs == null)
			modelRefs= new ArrayList<ModelReference> ();
		modelRefs.add(modelReference);
	}
	
	
	/**
	 * Get the modelReference of this operation.
	 *
	 * @return the modelReference value
	 */
	
	public ModelReference getModelReference(){
		if(modelRefs == null)
			return null;
		return modelRefs.get(0);
	}
	
	/**
	 * Set the precondition of this operation.
	 *
	 * @param preCondition the desired precondition
	 */
	public void setPreCondition(PreCondition preCondition){
		this.preCondition = preCondition;
	}
	
	/**
	 * Get the precondition of this operation.
	 *
	 * @return the precondition
	 */
	public PreCondition getPreCondition(){
		return this.preCondition;
	}
	
	/**
	 * Set the effect of this operation.
	 *
	 * @param effect the desired effect
	 */
	public void setEffect(Effect effect){
		this.effect = effect;
	}
	
	/**
	 * Get the effect of this operation.
	 *
	 * @return The effect
	 */
	public Effect getEffect(){
		return this.effect;
	}
	
	/**
	 * Set the name of this operation.
	 *
	 * @param name the desired name
	 */
	public void setName(String name)
	{
		this.name = name;
	}
	
	/**
	 * Get the name of this operation.
	 *
	 * @return the operation name
	 */
	public String getName()
	{
		return name;
	}
	
	/**
	 * Set the input message specification for this operation.
	 *
	 * @param input the new input message
	 */
	public void setRequest(Request request)
	{
		this.request = request;
	}
	
	/**
	 * Get the input message specification for this operation.
	 *
	 * @return the input message
	 */
	public Request getRequest()
	{
		return request;
	}
	
	/**
	 * Set the output message specification for this operation.
	 *
	 * @param output the new output message
	 */
	public void setResponse(Response response)
	{
		this.response = response;
	}
	
	/**
	 * Get the output message specification for this operation.
	 *
	 * @return the output message specification for the operation
	 */
	public Response getResponse()
	{
		return response;
	}
	
	
	
	/**
	 * Set the parameter ordering for a request-response,
	 * or solicit-response operation.
	 *
	 * @param parameterOrder a list of named parameters
	 * containing the part names to reflect the desired
	 * order of parameters for RPC-style operations
	 */
	public void setParameterOrdering(List parameterOrder)
	{
		this.parameterOrder = parameterOrder;
	}
	
	/**
	 * Get the parameter ordering for this operation.
	 *
	 * @return the parameter ordering, a list consisting
	 * of message part names
	 */
	public List getParameterOrdering()
	{
		return parameterOrder;
	}
	
	/**
	 * Set the documentation element for this document. This dependency
	 * on org.w3c.dom.Element should eventually be removed when a more
	 * appropriate way of representing this information is employed.
	 *
	 * @param docEl the documentation element
	 */
	public void setDocumentationElement(Element docEl)
	{
		this.docEl = docEl;
	}
	
	/**
	 * Get the documentation element. This dependency on org.w3c.dom.Element
	 * should eventually be removed when a more appropriate way of
	 * representing this information is employed.
	 *
	 * @return the documentation element
	 */
	public Element getDocumentationElement()
	{
		return docEl;
	}
	
	public void setUndefined(boolean isUndefined)
	{
		this.isUndefined = isUndefined;
	}
	
	public boolean isUndefined()
	{
		return isUndefined;
	}
	
	public String toString()
	{
		StringBuffer strBuf = new StringBuffer();
		
		strBuf.append("Operation: name=" + name);
		
		if (parameterOrder != null)
		{
			strBuf.append("\nparameterOrder=" + parameterOrder);
		}
		
	
		if (request != null)
		{
			strBuf.append("\n" + request);
		}
		
		if (response != null)
		{
			strBuf.append("\n" + response);
		}
		
		if (modelRefs != null)
			for(ModelReference ref : modelRefs) {
				strBuf.append('\n');
				strBuf.append(ref);
			}
		/*    if (modelRef != null)
		 {
		 strBuf.append("\n" + modelRef);
		 }*/
		
		if (preCondition != null)
		{
			strBuf.append("\n" + preCondition);
		}
		
		if (effect != null)
		{
			strBuf.append("\n" + effect);
		}
		
		return strBuf.toString();
	}
	
	public List<ModelReference> getModelReferences() {
		return modelRefs;
	}
	
	public void setModelReferences(List<ModelReference> refs) {
		modelRefs = refs;		
	}
}
