import warnings

with warnings.catch_warnings():
    warnings.simplefilter("ignore")
    import platform

    from jpype._jpackage import JPackage
    from jpype import *
    import os.path
    import sys

class Document(object):  

    #invoked to get methods described in a WADL document
    def getWADLMethods(self, wadlUrl, outputFileUrl ):

    #get environment variables JAVA_HOME and GALAXY_HOME
        javahome = os.environ.get('JAVA_HOME')
	galaxyhome=os.environ.get('GALAXY_HOME')

    #classpath, jarpath are variables pointing to the java libraries required to parse a WADL document
        classpath= galaxyhome + '/tools/WebServiceToolWorkflow/ParserForWADL/bin'
        jarpath = galaxyhome + '/tools/WebServiceToolWorkflow/ParserForWADL/lib/'
    
    #start JVM depending on the machine. The location of libjvm.so is assumed to be standard.
    #you can replace lines 28 to 35, with startJVM("LOCATION OF YOUR LIBJVM.SO","-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        machine = platform.machine()
        if machine == 'x86_64' :
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'i686' :
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        else :
            System.exit("Could not identify machine, please specify path to libjvm.so")
        
    #tell JPYPE that the package name is lsdis 
        pkg=JPackage('lsdis')
    
        urlToPass=java.net.URL(wadlUrl)	

    #convert __tilda__ to ~
	if(wadlUrl.find('__tilda__')>-1):
	    ulist = wadlUrl.split('__tilda__')
	    urlToPass = java.net.URL('~'.join(ulist))
        
   
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
         
        urls = []
        methods = []

    #using JPYPE call appropriate Java classes and methods to parse the WADL document and get a list of methods defined in it
        WADLParserDriver=pkg.WADLParserDriver
        wPD=WADLParserDriver()
        wPD.parse(urlToPass)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()
    
    #write the url of the WADL and the list of methods to the output in a tabular format, for the Step 2 tool to read from.
        i=0
        for url in urls:
            outputfile.write(wadlUrl+"\t")
            outputfile.write(str(methods[i].getId())+"\t")
            outputfile.write(str(url)+"\n")
            i=i+1
     	    


    #invoked to get REST methods described in a WSDL 2.0 document. Steps are similar to getWADLMethods except the library to parse WSDL 2.0 is used.
    def getWSDLMethods(self, wsdlUrl, outputFileUrl ):
        javahome = os.environ.get('JAVA_HOME')
	galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/restClientWSDL/WodenWSDLParser/bin'
        jarpath = galaxyhome + '/tools/restClientWSDL/WodenWSDLParser/lib/'
        machine = platform.machine()
        
    #start JVM depending on the machine. The location of libjvm.so is assumed to be standard.
    #you can replace lines 81 to 88, with startJVM("LOCATION OF YOUR LIBJVM.SO","-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        if machine == 'x86_64' :
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'i686' :
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        else :
            System.exit("Could not identify machine, please specify path to libjvm.so")
    
        pkg=JPackage('lsdis')
       
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
        length=(len(sys.argv))
    
        urls = []
        methods = []

	if(wsdlUrl.find('__tilda__')>-1):
	    ulist = wsdlUrl.split('__tilda__')
	    urlToPass = '~'.join(ulist)

        WSDLParserDriver=pkg.WSDLParserDriver
        wPD=WSDLParserDriver()
        wPD.parse(urlToPass)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()
        	            
        i=0
        for url in urls:
           outputfile.write(wsdlUrl+"\t")
           outputfile.write(str(methods[i].getName().getLocalPart())+"\t")
           outputfile.write(str(url)+"\n")
           i=i+1
         
       
    # invoked to get methods described in a SAWADL document    
    def getSAWADLMethods(self, sawadlUrl, outputFileUrl ):
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/restclientSAWADL/lib/SAWADLParser/bin'
        machine = platform.machine()
        
    #start JVM depending on the machine. The location of libjvm.so is assumed to be standard.
    #you can replace lines 126 to 133, with startJVM("LOCATION OF YOUR LIBJVM.SO","-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)        
        if machine == 'x86_64' :
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)
        elif machine == 'i686' :
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)            
        else :
            System.exit("Could not identify machine, please specify path to libjvm.so")
    
        pkg=JPackage('edu.uga.cs.lsdis.meteors.wadls')
        

   
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
   
	if(sawadlUrl.find('__tilda__')>-1):
	    ulist = sawadlUrl.split('__tilda__')
	    urlToPass = '~'.join(ulist)
	         
        urls = []
        methods = []


        SAWADLParserDriver=pkg.SAWADLParserDriver
        sawPD=SAWADLParserDriver()
        sawPD.parse(urlToPass)
        urls = sawPD.getUrl()
        methods = sawPD.getCompleteMethodList()
        
        i=0
        for url in urls:
           outputfile.write(sawadlUrl+"\t")
           outputfile.write(str(methods[i].getName())+"\t")    
           outputfile.write(str(url)+"\n")
           i=i+1
           

  
       
   
