/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OWL2Datatype {
    RDF_XML_LITERAL(Namespaces.RDF, "XMLLiteral", Category.STRING_WITHOUT_LANGUAGE_TAG, false, ".*"),
    OWL_REAL(Namespaces.OWL, "real", Category.NUMBER, false, ".*"),
    OWL_RATIONAL(Namespaces.OWL, "rational", Category.NUMBER, false, "(\\+|-)?([0-9]+)(\\s)*(/)(\\s)*([0-9]+)"),
    XSD_DECIMAL(XSDVocabulary.DECIMAL, Category.NUMBER, false, "(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)"),
    XSD_INTEGER(XSDVocabulary.INTEGER, Category.NUMBER, false, "(\\+|-)?([0-9]+)"),
    XSD_NON_NEGATIVE_INTEGER(XSDVocabulary.NON_NEGATIVE_INTEGER, Category.NUMBER, false, "((\\+)?([0-9]+))|-(0+)"),
    XSD_NON_POSITIVE_INTEGER(XSDVocabulary.NON_POSITIVE_INTEGER, Category.NUMBER, false, "-([0-9]+)|(\\+(0+))"),
    XSD_POSITIVE_INTEGER(XSDVocabulary.POSITIVE_INTEGER, Category.NUMBER, false, "(\\+)?([0-9]+)"),
    XSD_NEGATIVE_INTEGER(XSDVocabulary.NEGATIVE_INTEGER, Category.NUMBER, false, "-([0-9]+)"),
    XSD_LONG(XSDVocabulary.LONG, Category.NUMBER, true, "(\\+|-)?([0-9]+)"),
    XSD_INT(XSDVocabulary.INT, Category.NUMBER, true, "(\\+|-)?([0-9]+)"),
    XSD_SHORT(XSDVocabulary.SHORT, Category.NUMBER, true, "(\\+|-)?([0-9]+)"),
    XSD_BYTE(XSDVocabulary.BYTE, Category.NUMBER, true, "(\\+|-)?([0-9]+)"),
    XSD_UNSIGNED_LONG(XSDVocabulary.UNSIGNED_LONG, Category.NUMBER, true, "(\\+)?([0-9]+)"),
    XSD_UNSIGNED_INT(XSDVocabulary.UNSIGNED_INT, Category.NUMBER, true, "(\\+)?([0-9]+)"),
    XSD_UNSIGNED_SHORT(XSDVocabulary.UNSIGNED_SHORT, Category.NUMBER, true, "(\\+)?([0-9]+)"),
    XSD_UNSIGNED_BYTE(XSDVocabulary.UNSIGNED_BYTE, Category.NUMBER, true, "(\\+)?([0-9]+)"),
    XSD_DOUBLE(XSDVocabulary.DOUBLE, Category.NUMBER, true, "(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)? |(\\+|-)?INF|NaN"),
    XSD_FLOAT(XSDVocabulary.FLOAT, Category.NUMBER, true, "(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?|(\\+|-)?INF|NaN"),
    XSD_STRING(XSDVocabulary.STRING, Category.STRING_WITHOUT_LANGUAGE_TAG, false, ".*"),
    XSD_NORMALIZED_STRING(XSDVocabulary.NORMALIZED_STRING, Category.STRING_WITHOUT_LANGUAGE_TAG, false, "([^\\r\\n\\t])*"),
    XSD_TOKEN(XSDVocabulary.TOKEN, Category.STRING_WITHOUT_LANGUAGE_TAG, false, "([^\\s])(\\s([^\\s])|([^\\s]))*"),
    XSD_LANGUAGE(XSDVocabulary.LANGUAGE, Category.STRING_WITHOUT_LANGUAGE_TAG, true, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*"),
    XSD_NAME(XSDVocabulary.NAME, Category.STRING_WITHOUT_LANGUAGE_TAG, false, ": | [A-Z] | _ | [a-z] | [\\u00C0-\\u00D6] | [\\u00D8-\\u00F6] | [\\u00F8-\\u02FF] | [\\u0370-\\u037D] | [\\u037F-\\u1FFF] | [\\u200C-\\u200D] | [\\u2070-\\u218F] | [\\u2C00-\\u2FEF] | [\\u3001-\\uD7FF] | [\\uF900-\\uFDCF] | [\\uFDF0-\\uFFFD] (: | [A-Z] | _ | [a-z] | [\\u00C0-\\u00D6] | [\\u00D8-\\u00F6] | [\\u00F8-\\u02FF] | [\\u0370-\\u037D] | [\\u037F-\\u1FFF] | [\\u200C-\\u200D] | [\\u2070-\\u218F] | [\\u2C00-\\u2FEF] | [\\u3001-\\uD7FF] | [\\uF900-\\uFDCF] | [\\uFDF0-\\uFFFD] | \"-\" | \".\" | [0-9] | \\u00B7 | [\\u0300-\\u036F] | [\\u203F-\\u2040])*"),
    XSD_NCNAME(XSDVocabulary.NCNAME, Category.STRING_WITHOUT_LANGUAGE_TAG, false, "[A-Z] | _ | [a-z] | [\\u00C0-\\u00D6] | [\\u00D8-\\u00F6] | [\\u00F8-\\u02FF] | [\\u0370-\\u037D] | [\\u037F-\\u1FFF] | [\\u200C-\\u200D] | [\\u2070-\\u218F] | [\\u2C00-\\u2FEF] | [\\u3001-\\uD7FF] | [\\uF900-\\uFDCF] | [\\uFDF0-\\uFFFD] ([A-Z] | _ | [a-z] | [\\u00C0-\\u00D6] | [\\u00D8-\\u00F6] | [\\u00F8-\\u02FF] | [\\u0370-\\u037D] | [\\u037F-\\u1FFF] | [\\u200C-\\u200D] | [\\u2070-\\u218F] | [\\u2C00-\\u2FEF] | [\\u3001-\\uD7FF] | [\\uF900-\\uFDCF] | [\\uFDF0-\\uFFFD] | \"-\" | \".\" | [0-9] | \\u00B7 | [\\u0300-\\u036F] | [\\u203F-\\u2040])*"),
    XSD_NMTOKEN(XSDVocabulary.NMTOKEN, Category.STRING_WITHOUT_LANGUAGE_TAG, false, ".*"),
    XSD_BOOLEAN(XSDVocabulary.BOOLEAN, Category.BOOLEAN, true, "true|false|1|0"),
    XSD_HEX_BINARY(XSDVocabulary.HEX_BINARY, Category.BINARY, false, "([0-9a-fA-F]{2})*"),
    XSD_BASE_64_BINARY(XSDVocabulary.BASE_64_BINARY, Category.BINARY, false, "((([A-Za-z0-9+/] ?){4})*(([A-Za-z0-9+/] ?){3}[A-Za-z0-9+/]|([A-Za-z0-9+/] ?){2}[AEIMQUYcgkosw048] ?=|[A-Za-z0-9+/] ?[AQgw] ?= ?=))?"),
    XSD_ANY_URI(XSDVocabulary.ANY_URI, Category.URI, false, ".*"),
    XSD_DATE_TIME(XSDVocabulary.DATE_TIME, Category.TIME, false, "-?([1-9][0-9]{3,}|0[0-9]{3})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?|(24:00:00(\\.0+)?))(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?"),
    XSD_DATE_TIME_STAMP(XSDVocabulary.DATE_TIME_STAMP, Category.TIME, false, "-?([1-9][0-9]{3,}|0[0-9]{3})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\\\.[0-9]+)?|(24:00:00(\\\\.0+)?))(Z|(\\\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))");

    private static final Set<IRI> ALL_IRIS;
    private String shortName;
    private IRI iri;
    private Category category;
    private boolean finite;
    private Pattern pattern;

    public static Set<IRI> getDatatypeIRIs() {
        return ALL_IRIS;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public static boolean isBuiltIn(IRI datatypeIRI) {
        return ALL_IRIS.contains(datatypeIRI);
    }

    public static OWL2Datatype getDatatype(IRI datatype) {
        if (!OWL2Datatype.isBuiltIn(datatype)) {
            throw new OWLRuntimeException(datatype + " is not a built in datatype!");
        }
        for (OWL2Datatype v : OWL2Datatype.values()) {
            if (!v.getIRI().equals(datatype)) continue;
            return v;
        }
        throw new OWLRuntimeException(datatype + " is not a built in datatype!");
    }

    private OWL2Datatype(Namespaces namespace, String shortName, Category category, boolean finite, String regEx) {
        this.iri = IRI.create((Object)((Object)namespace) + shortName);
        this.shortName = shortName;
        this.category = category;
        this.finite = finite;
        if (regEx != null) {
            this.pattern = Pattern.compile(regEx, 32);
        }
    }

    private OWL2Datatype(XSDVocabulary xsd, Category category, boolean finite, String regEx) {
        this.iri = xsd.getIRI();
        this.shortName = xsd.getShortName();
        this.category = category;
        this.finite = finite;
        this.pattern = Pattern.compile(regEx, 32);
    }

    public String getShortName() {
        return this.shortName;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public URI getURI() {
        return this.iri.toURI();
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isNumeric() {
        return this.category.equals((Object)Category.NUMBER);
    }

    public boolean isFinite() {
        return this.finite;
    }

    public Collection<OWLFacet> getFacets() {
        return this.category.getFacets();
    }

    public boolean isInLexicalSpace(String s) {
        return this.pattern.matcher(s).matches();
    }

    public static void main(String[] args) {
        for (OWL2Datatype v : OWL2Datatype.values()) {
            System.out.println((Object)v);
        }
        boolean matches = OWL_RATIONAL.getPattern().matcher("22/7").matches();
        System.out.println("MATCH: " + matches);
    }

    static {
        HashSet<IRI> uris = new HashSet<IRI>();
        for (OWL2Datatype v : OWL2Datatype.values()) {
            uris.add(v.getIRI());
        }
        ALL_IRIS = Collections.unmodifiableSet(new TreeSet(uris));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WhiteSpaceNormalisation {
        PRESERVE,
        REPLACE,
        COLLAPSE;


        public String getNormalisedString(String s) {
            switch (this) {
                case REPLACE: {
                    return s.replaceAll("\\t|\\n|\\r", " ");
                }
                case COLLAPSE: {
                    return REPLACE.getNormalisedString(s).replaceAll("\\s+", " ").trim();
                }
            }
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        NUMBER("Number", OWLFacet.MIN_INCLUSIVE, OWLFacet.MAX_INCLUSIVE, OWLFacet.MIN_EXCLUSIVE, OWLFacet.MAX_EXCLUSIVE),
        STRING_WITH_LANGUAGE_TAG("String with a language tag", OWLFacet.MIN_LENGTH, OWLFacet.MAX_LENGTH, OWLFacet.LENGTH, OWLFacet.PATTERN, OWLFacet.LANG_PATTERN),
        STRING_WITHOUT_LANGUAGE_TAG("String without a language tag", OWLFacet.MIN_LENGTH, OWLFacet.MAX_LENGTH, OWLFacet.LENGTH, OWLFacet.PATTERN),
        BOOLEAN("Boolean value", new OWLFacet[0]),
        BINARY("Binary data", OWLFacet.MIN_LENGTH, OWLFacet.MAX_LENGTH, OWLFacet.LENGTH),
        URI("URI", OWLFacet.MIN_LENGTH, OWLFacet.MAX_LENGTH, OWLFacet.PATTERN),
        TIME("Time instant", OWLFacet.MIN_INCLUSIVE, OWLFacet.MAX_INCLUSIVE, OWLFacet.MIN_EXCLUSIVE, OWLFacet.MAX_EXCLUSIVE);

        private String name;
        private Set<OWLFacet> facets;

        private Category(String name, OWLFacet ... facets) {
            this.name = name;
            HashSet<OWLFacet> f = new HashSet<OWLFacet>(facets.length);
            f.addAll(Arrays.asList(facets));
            this.facets = Collections.unmodifiableSet(f);
        }

        public String getName() {
            return this.name;
        }

        public Set<OWLFacet> getFacets() {
            return this.facets;
        }
    }
}

