/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public abstract class IRI
implements OWLAnnotationSubject,
OWLAnnotationValue,
SWRLPredicate {
    private static Map<String, String> prefixCache = new HashMap<String, String>();

    public abstract URI toURI();

    public abstract boolean isAbsolute();

    public abstract String getScheme();

    public abstract IRI resolve(String var1);

    public abstract boolean isReservedVocabulary();

    public abstract boolean isThing();

    public abstract boolean isNothing();

    public abstract String getFragment();

    public abstract String toQuotedString();

    public static IRI create(String str) {
        if (str == null) {
            throw new NullPointerException("String must not be null");
        }
        return new IRIImpl(str);
    }

    public static IRI create(File file) {
        return new IRIImpl(file.toURI());
    }

    public static IRI create(URI uri) {
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        return new IRIImpl(uri);
    }

    public static IRI create(URL url) throws URISyntaxException {
        if (url == null) {
            throw new NullPointerException("URL must not be null");
        }
        return new IRIImpl(url.toURI());
    }

    public static IRI generateDocumentIRI() {
        return IRI.create("owlapi:ontology" + System.nanoTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IRIImpl
    extends IRI {
        private String remainder;
        private String prefix;
        private int hashCode = 0;

        public IRIImpl(String s) {
            int fragmentSeparatorIndex = s.lastIndexOf(35);
            if (fragmentSeparatorIndex != -1 && fragmentSeparatorIndex < s.length()) {
                this.remainder = s.substring(fragmentSeparatorIndex + 1);
                this.prefix = s.substring(0, fragmentSeparatorIndex + 1);
            } else {
                int pathSeparatorIndex = s.lastIndexOf(47);
                if (pathSeparatorIndex != -1 && pathSeparatorIndex < s.length()) {
                    this.remainder = s.substring(pathSeparatorIndex + 1);
                    this.prefix = s.substring(0, pathSeparatorIndex + 1);
                } else {
                    this.remainder = null;
                    this.prefix = s;
                }
            }
            String cached = (String)prefixCache.get(this.prefix);
            if (cached == null) {
                prefixCache.put(this.prefix, this.prefix);
            } else {
                this.prefix = cached;
            }
        }

        public IRIImpl(URI uri) {
            this(uri.toString());
        }

        @Override
        public URI toURI() {
            if (this.remainder != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.prefix);
                sb.append(this.remainder);
                return URI.create(sb.toString());
            }
            return URI.create(this.prefix);
        }

        @Override
        public IRI resolve(String s) {
            return IRI.create(this.toURI().resolve(s));
        }

        @Override
        public String getScheme() {
            int colonIndex = this.prefix.indexOf(":");
            if (colonIndex == -1) {
                return null;
            }
            return this.prefix.substring(0, colonIndex);
        }

        @Override
        public boolean isAbsolute() {
            int colonIndex = this.prefix.indexOf(58);
            if (colonIndex == -1) {
                return false;
            }
            for (int i = 0; i < colonIndex; ++i) {
                char ch = this.prefix.charAt(i);
                if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '.' || ch == '+' || ch == '-') continue;
                return false;
            }
            return true;
        }

        @Override
        public String getFragment() {
            if (this.prefix.endsWith("#")) {
                return this.remainder;
            }
            return null;
        }

        @Override
        public boolean isNothing() {
            return this.equals(OWLRDFVocabulary.OWL_NOTHING.getIRI());
        }

        @Override
        public boolean isReservedVocabulary() {
            return this.prefix.startsWith(Namespaces.OWL.toString()) || this.prefix.startsWith(Namespaces.RDF.toString()) || this.prefix.startsWith(Namespaces.RDFS.toString()) || this.prefix.startsWith(Namespaces.XSD.toString());
        }

        @Override
        public boolean isThing() {
            return this.remainder != null && this.remainder.equals("Thing") && this.prefix.equals(Namespaces.OWL.toString());
        }

        @Override
        public void accept(OWLObjectVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <O> O accept(OWLObjectVisitorEx<O> visitor) {
            return visitor.visit(this);
        }

        @Override
        public void accept(OWLAnnotationSubjectVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <E> E accept(OWLAnnotationSubjectVisitorEx<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public Set<OWLClass> getClassesInSignature() {
            return Collections.emptySet();
        }

        @Override
        public Set<OWLDataProperty> getDataPropertiesInSignature() {
            return Collections.emptySet();
        }

        @Override
        public Set<OWLNamedIndividual> getIndividualsInSignature() {
            return Collections.emptySet();
        }

        @Override
        public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
            return Collections.emptySet();
        }

        @Override
        public Set<OWLEntity> getSignature() {
            return Collections.emptySet();
        }

        @Override
        public Set<OWLDatatype> getDatatypesInSignature() {
            return Collections.emptySet();
        }

        @Override
        public int compareTo(OWLObject o) {
            if (o == this) {
                return 0;
            }
            if (!(o instanceof IRIImpl)) {
                return -1;
            }
            IRIImpl other = (IRIImpl)o;
            int diff = this.prefix.compareTo(other.prefix);
            if (diff != 0) {
                return diff;
            }
            String otherRemainder = other.remainder;
            if (this.remainder == null) {
                if (otherRemainder == null) {
                    return 0;
                }
                return -1;
            }
            if (otherRemainder == null) {
                return 1;
            }
            return this.remainder.compareTo(otherRemainder);
        }

        public String toString() {
            if (this.remainder != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.prefix);
                sb.append(this.remainder);
                return sb.toString();
            }
            return this.prefix;
        }

        @Override
        public String toQuotedString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<");
            sb.append(this.prefix);
            if (this.remainder != null) {
                sb.append(this.remainder);
            }
            sb.append(">");
            return sb.toString();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.prefix.hashCode() + (this.remainder != null ? this.remainder.hashCode() : 0);
            }
            return this.hashCode;
        }

        @Override
        public void accept(OWLAnnotationValueVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
            return visitor.visit(this);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IRIImpl)) {
                return false;
            }
            IRIImpl other = (IRIImpl)obj;
            String otherRemainder = other.remainder;
            if (this.remainder == null) {
                if (otherRemainder == null) {
                    return this.prefix.equals(other.prefix);
                }
                return false;
            }
            if (otherRemainder == null) {
                return false;
            }
            return this.remainder.equals(otherRemainder) && other.prefix.equals(this.prefix);
        }
    }
}

