/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;
import org.semanticweb.owlapi.util.RootClassChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRootClassChecker
implements RootClassChecker {
    private Set<OWLOntology> ontologies;
    private RootClassCheckerHelper checker = new RootClassCheckerHelper();
    private NamedSuperChecker superChecker = new NamedSuperChecker();

    public SimpleRootClassChecker(Set<OWLOntology> ontologies) {
        this.ontologies = ontologies;
    }

    @Override
    public boolean isRootClass(OWLClass cls) {
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getReferencingAxioms(cls)) {
                this.checker.setOWLClass(cls);
                ax.accept(this.checker);
                if (this.checker.isRoot()) continue;
                return false;
            }
        }
        return true;
    }

    private class RootClassCheckerHelper
    extends OWLAxiomVisitorAdapter {
        private boolean isRoot;
        private OWLClass cls;

        private RootClassCheckerHelper() {
        }

        public void setOWLClass(OWLClass cls) {
            this.isRoot = true;
            this.cls = cls;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (axiom.getSubClass().equals(this.cls)) {
                SimpleRootClassChecker.this.superChecker.reset();
                axiom.getSuperClass().accept(SimpleRootClassChecker.this.superChecker);
                this.isRoot = !SimpleRootClassChecker.this.superChecker.namedSuper;
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            Set<OWLClassExpression> descs = axiom.getClassExpressions();
            if (!descs.contains(this.cls)) {
                return;
            }
            for (OWLClassExpression desc : descs) {
                if (desc.equals(this.cls)) continue;
                SimpleRootClassChecker.this.superChecker.reset();
                desc.accept(SimpleRootClassChecker.this.superChecker);
                if (!SimpleRootClassChecker.this.superChecker.namedSuper) continue;
                this.isRoot = false;
                return;
            }
            this.isRoot = !SimpleRootClassChecker.this.superChecker.namedSuper;
        }
    }

    private class NamedSuperChecker
    extends OWLClassExpressionVisitorAdapter {
        private boolean namedSuper;

        private NamedSuperChecker() {
        }

        public void reset() {
            this.namedSuper = false;
        }

        public void visit(OWLClass desc) {
            this.namedSuper = true;
        }

        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression op : desc.getOperands()) {
                op.accept(this);
                if (!this.namedSuper) continue;
                break;
            }
        }
    }
}

