/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLEntityURIConverterStrategy;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityURIConverter {
    private OWLOntologyManager manager;
    private Set<OWLOntology> ontologies;
    private Map<OWLEntity, IRI> replacementMap;
    private List<OWLOntologyChange> changes;
    private Set<OWLEntity> processedEntities;
    private OWLEntityURIConverterStrategy strategy;

    public OWLEntityURIConverter(OWLOntologyManager manager, Set<OWLOntology> ontologies, OWLEntityURIConverterStrategy strategy) {
        this.manager = manager;
        this.ontologies = new HashSet<OWLOntology>(ontologies);
        this.strategy = strategy;
    }

    public List<OWLOntologyChange> getChanges() {
        this.replacementMap = new HashMap<OWLEntity, IRI>();
        this.processedEntities = new HashSet<OWLEntity>();
        this.changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLClass oWLClass : ont.getClassesInSignature()) {
                if (oWLClass.isOWLThing() || oWLClass.isOWLNothing()) continue;
                this.processEntity(oWLClass);
            }
            for (OWLObjectProperty oWLObjectProperty : ont.getObjectPropertiesInSignature()) {
                this.processEntity(oWLObjectProperty);
            }
            for (OWLDataProperty oWLDataProperty : ont.getDataPropertiesInSignature()) {
                this.processEntity(oWLDataProperty);
            }
            for (OWLNamedIndividual oWLNamedIndividual : ont.getIndividualsInSignature()) {
                this.processEntity(oWLNamedIndividual);
            }
        }
        OWLObjectDuplicator dup = new OWLObjectDuplicator(this.replacementMap, this.manager.getOWLDataFactory());
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getAxioms()) {
                OWLAxiom dupAx = (OWLAxiom)dup.duplicateObject(ax);
                if (dupAx.equals(ax)) continue;
                this.changes.add(new RemoveAxiom(ont, ax));
                this.changes.add(new AddAxiom(ont, dupAx));
            }
        }
        return this.changes;
    }

    private void processEntity(OWLEntity ent) {
        if (this.processedEntities.contains(ent)) {
            return;
        }
        IRI rep = this.getTinyURI(ent);
        this.replacementMap.put(ent, rep);
        this.processedEntities.add(ent);
    }

    private IRI getTinyURI(OWLEntity ent) {
        return this.strategy.getConvertedIRI(ent);
    }
}

