package javax.wadls;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * This interface represents a ModelReference.
 * 
 * @author Zixin Wu (wuzixin@uga.edu)
 *
 */
public interface ModelReference {

	/**
	 * Get the concept of this modelReference.
	 * @return The concept of this modelReference.
	 */
	public String getConcept();

	/**
	 * Set the concept of this modelReference.
	 * @param concept The desired concept of this modelReference.
	 */
	public void setConcept(String concept);

	/**
	 * Get the prefix of this modelReference
	 * @return The prefix  of this modelReference
	 */
	public String getPrefix();

	/**
	 * Set the prefix of the ontology used in this modelReference
	 * @param prefix The desired prefix of the ontology used in this modelReference
	 */
	public void setPrefix(String prefix);

	/**
	 * Get the namespace of the ontology used in this modelReference
	 * @return The namespace of the ontology used in this modelReference
	 */
	public URI getNamespace();

	/**
	 * Set the namespace of the ontology used in this modelReference
	 * @param nameSpace The desired namespace of the ontology used in this modelReference
	 */
	public void setNamespace(String nameSpace)
			throws URISyntaxException;

	/**
	 * Get the parent object of this modelReference
	 * @return The parent object of this modelReference
	 */
	public Object getParent();

	/**
	 * Set the parent object of this modelReference
	 * @param parent The desired parent object of this modelReference
	 */
	public void setParent(Object parent);
	
	/**
	 * Set the value of this modelReference by parsing the formatted string.
	 * @param modelReferenceAsString The formatted string
	 * @param def WSDLS definition
	 * @throws URISyntaxException 
	 * @throws WSDLSException 
	 */
	public void valueOf(String modelReferenceAsString, Application app) throws URISyntaxException, WADLSException;
	
	/**
	 * Return a formatted string representing this modelReference.
	 * @return A formatted string representing this modelReference.
	 */
	public String value();
}