/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStringLiteral;
import org.semanticweb.owlapi.model.OWLTypedLiteral;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLStringLiteralImpl
extends OWLLiteralImpl
implements OWLStringLiteral {
    private String lang;

    public OWLStringLiteralImpl(OWLDataFactory dataFactory, String literal, String lang) {
        super(dataFactory, literal);
        this.lang = lang != null && lang.length() > 0 ? lang : null;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    public boolean hasLang() {
        return this.lang != null;
    }

    @Override
    public boolean isOWLStringLiteral() {
        return true;
    }

    @Override
    public OWLDatatype getDatatype() {
        return null;
    }

    @Override
    public boolean hasLang(String lang) {
        return lang != null && this.lang != null && this.lang.equals(lang);
    }

    @Override
    public boolean isOWLTypedLiteral() {
        return false;
    }

    @Override
    public OWLTypedLiteral asOWLTypedLiteral() {
        throw new OWLRuntimeException("Not a typed constant!");
    }

    @Override
    public OWLStringLiteral asOWLStringLiteral() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof OWLStringLiteral) {
            String otherLang = ((OWLStringLiteral)obj).getLang();
            if (otherLang != null) {
                return otherLang.equals(this.lang);
            }
            return this.lang == null;
        }
        return false;
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLStringLiteral other = (OWLStringLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        if (this.getLang() == null) {
            if (other.getLang() == null) {
                return 0;
            }
            return -1;
        }
        if (other.getLang() == null) {
            return 1;
        }
        return this.getLang().compareTo(other.getLang());
    }
}

