package edu.uga.cs.lsdis.meteors.wadls;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.wadls.Application;
import javax.wadls.Method;
import javax.wadls.Param;
import javax.wadls.Request;
import javax.wadls.Resource;
import javax.wadls.WADLSException;
import javax.wadls.factory.WADLFactory;
import javax.wadls.xml.WADLReader;
import javax.xml.namespace.QName;


public class SAWADLParserDriver {
		 
		
		 private List<Method> completeMethodList = new ArrayList<Method>();
		 private  List<String> url = new ArrayList<String>();
		 private List<String> paramList = new ArrayList<String>();
		 private List<String> paramTypeList = new ArrayList<String>();
		 private List<String> paramModelRef = new ArrayList<String>();
		 private Application application;
			 
		 
		 public List<Method> getCompleteMethodList() {
			return completeMethodList;
		 }

		public List<String> getUrl() {
			return url;
		 }
				
		public List<String> getParamList() {
			return paramList;
		 }
		public List<String> getParamTypeList() {
			return paramTypeList;
		 }


		
		 
		public static void main(String[] args) throws Exception {

		//WADLParserDriver mpw = new WADLParserDriver();
		//mpw.parse(new URL(args[0]));
		SAWADLParserDriver spd = new SAWADLParserDriver();
		//String fileURL = "/home/ganjoo/parser/SAWADLParser/Files/sample.wadl";
		String fileURL = "/home/ganjoo/parser/SAWADLParser/euPathWADL/GenesByTextSearch.sawadl";
		//String fileURL = "http://cs.uga.edu/~ganjoo/galaxy/GenesByTextSearch.sawadl";
		spd.parse(fileURL);
		}
		
		public void parse(String fileURL) throws Exception {
			int i=0;
			Map resources = new HashMap();
			List methods = new Vector();
			List<ParamImpl> paramList = new Vector();
			
			//URL fileURL = new URL("http://www.eupathdb.org/webservices/GeneQuestions/GenesByMolecularWeight.wadl");
			WADLReader wadlReader;
			try {
				wadlReader = WADLFactory.newInstance().newWADLReader();
				wadlReader.setFeature(Constants.FEATURE_PARSE_SAWADL,true);
				//wadlReader.setExtensionRegistry(new PopulatedExtensionRegistry());
				Application app  = wadlReader.readWADL(fileURL);
				this.application = app;
			
			
			String temp = "";
		    String tempHref="";
		    int count =0;
		    Map<QName, Resource> resourceMap = app.getResources();
		    for(Map.Entry entry : resourceMap.entrySet() ){
		    	count++;
		    	Resource resource = (Resource) entry.getValue();
		   //   System.out.println("Resource " + count + "is " + resource.getQName().getNamespaceURI());
		    
		    	methods = resource.getMethods();
		   
		    	for(int j =0;j<methods.size();j++){
		    
		    		Method method = (Method) methods.get(j);
		    		completeMethodList.add(method);
		    		url.add(app.getResourcesPath()+resource.getQName().getLocalPart());
		    		
		    		System.out.println("-------------------------------\n");
		    		System.out.println("Resources path : " + app.getResourcesPath());
		    		System.out.println("Method name is : " + method.getName());
		    		System.out.println("Qname uri : " + resource.getQName().getNamespaceURI());
		    		System.out.println("Qname local part : " + resource.getQName().getLocalPart());
		    		System.out.println("Qname prefix : " + resource.getQName().getPrefix());
		    		System.out.println("\n-------------------------------\n");
		           
		    		Request request = method.getRequest();
		    		paramList = request.getParamList();
		    		
//		    		Map namespaces = new HashMap();
//		    		namespaces = app.getNamespaces();
//		    		System.out.println(	namespaces.get("euPathOntology"));
		    		
		    		for(Param param : paramList){
		    			System.out.println("Parameter : ");
		    			System.out.println("\t name: "+ param.getName());
		    			System.out.println("\t type: "+param.getType());
		    			System.out.println("\t ontology reference: "+ param.getModelreference());
		    			System.out.println("\t required: " + param.getRequired());
		    			System.out.println("\t option size: "+param.getOptionvalue().size());
		    			
		    			
		    		}
		    		
		    	    
		    	}
		    
		    
		    
		    }
		    

		    
		  		    
		    
		   
		    
			} catch (WADLSException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			
			}  
	}
		
		public String getCompleteModelReference(Param param){
			String prefix = null;
			String namespace = null;
			if(param.getModelreference() != null){
				prefix = param.getModelreference().split("#")[0];
			    namespace = application.getNamespace(prefix);
			}
			
			return namespace+"#"+param.getModelreference().split("#")[1];
		}
		
		
}
