/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWL2Profile;
import org.semanticweb.owlapi.profiles.OWL2QLProfile;
import org.semanticweb.owlapi.profiles.OWL2RLProfile;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxOWLObjectRendererImpl;

public class ProfilesTest {
    public static void main(String[] args) {
        try {
            DefaultPrefixManager pm = new DefaultPrefixManager("http://protege.cim3.net/file/pub/ontologies/tambis/tambis-full.owl#");
            SimpleShortFormProvider sfp = new SimpleShortFormProvider();
            ManchesterOWLSyntaxOWLObjectRendererImpl ren = new ManchesterOWLSyntaxOWLObjectRendererImpl();
            ren.setShortFormProvider(sfp);
            ToStringRenderer.getInstance().setRenderer(ren);
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.loadOntologyFromOntologyDocument(IRI.create("http://owl.cs.manchester.ac.uk/repository/download?ontology=http://protege.cim3.net/file/pub/ontologies/tambis/tambis-full.owl&format=RDF/XML"));
            System.out.println("Loaded ontology");
            ProfilesTest.check(ont, new OWL2Profile());
            ProfilesTest.check(ont, new OWL2DLProfile());
            ProfilesTest.check(ont, new OWL2ELProfile());
            ProfilesTest.check(ont, new OWL2QLProfile());
            ProfilesTest.check(ont, new OWL2RLProfile());
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }

    private static void check(OWLOntology ont, OWLProfile profile) {
        System.out.println("Checking ontology is in " + profile.getName());
        OWLProfileReport report = profile.checkOntology(ont);
        System.out.println(report);
        System.out.println("--------------------------------------------------------------------------");
    }
}

