/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLProfileReport {
    private OWLProfile profile;
    private Set<OWLProfileViolation> violations;

    public OWLProfileReport(OWLProfile profile, Set<OWLProfileViolation> violations) {
        this.profile = profile;
        this.violations = Collections.unmodifiableSet(new LinkedHashSet<OWLProfileViolation>(violations));
    }

    public OWLProfile getProfile() {
        return this.profile;
    }

    public boolean isInProfile() {
        return this.violations.isEmpty();
    }

    public Set<OWLProfileViolation> getViolations() {
        return this.violations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.profile.getName());
        sb.append(" Profile Report: ");
        if (this.isInProfile()) {
            sb.append("[Ontology and imports closure in profile]\n");
        } else {
            sb.append("Ontology and imports closure NOT in profile. ");
            sb.append("The following violations are present: ");
            sb.append(":\n");
        }
        for (OWLProfileViolation na : this.violations) {
            sb.append(na);
            sb.append("\n");
        }
        return sb.toString();
    }
}

