/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import org.semanticweb.owlapi.model.OWLException;

public class OWLParserException
extends OWLException {
    private int lineNumber;
    private int columnNumber;

    public OWLParserException() {
        this.lineNumber = -1;
    }

    public OWLParserException(String message) {
        super(message);
        this.lineNumber = -1;
    }

    public OWLParserException(String message, Throwable cause) {
        super(message, cause);
        this.lineNumber = -1;
    }

    public OWLParserException(Throwable cause) {
        super(cause);
        this.lineNumber = -1;
    }

    public OWLParserException(String message, int lineNumber, int columnNumber) {
        super(message);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public OWLParserException(Throwable cause, int lineNumber, int columnNumber) {
        super(cause);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getMessage() {
        if (this.lineNumber != -1) {
            return super.getMessage() + " (Line " + this.lineNumber + ")";
        }
        return super.getMessage();
    }
}

