/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredIndividualAxiomGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferredPropertyAssertionGenerator
extends InferredIndividualAxiomGenerator<OWLPropertyAssertionAxiom> {
    @Override
    protected void addAxioms(OWLNamedIndividual entity, OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLPropertyAssertionAxiom> result) {
        for (OWLObjectProperty oWLObjectProperty : reasoner.getRootOntology().getObjectPropertiesInSignature(true)) {
            for (OWLNamedIndividual oWLNamedIndividual : reasoner.getObjectPropertyValues(entity, oWLObjectProperty).getFlattened()) {
                result.add(dataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectProperty, entity, oWLNamedIndividual));
            }
        }
        for (OWLDataProperty oWLDataProperty : reasoner.getRootOntology().getDataPropertiesInSignature(true)) {
            for (OWLLiteral oWLLiteral : reasoner.getDataPropertyValues(entity, oWLDataProperty)) {
                result.add(dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLDataProperty, (OWLIndividual)entity, oWLLiteral));
            }
        }
    }

    @Override
    public String getLabel() {
        return "Property assertions (property values)";
    }
}

