/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLNaryIndividualAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDifferentIndividualsAxiomImpl
extends OWLNaryIndividualAxiomImpl
implements OWLDifferentIndividualsAxiom {
    public OWLDifferentIndividualsAxiomImpl(OWLDataFactory dataFactory, Set<? extends OWLIndividual> individuals, Set<? extends OWLAnnotation> annotations) {
        super(dataFactory, individuals, annotations);
    }

    @Override
    public OWLDifferentIndividualsAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return this.getOWLDataFactory().getOWLDifferentIndividualsAxiom(this.getIndividuals());
    }

    @Override
    public OWLDifferentIndividualsAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return this.getOWLDataFactory().getOWLDifferentIndividualsAxiom(this.getIndividuals(), this.mergeAnnos(annotations));
    }

    @Override
    public Set<OWLDifferentIndividualsAxiom> asPairwiseAxioms() {
        List<OWLIndividual> individuals = this.getIndividualsAsList();
        HashSet<OWLDifferentIndividualsAxiom> result = new HashSet<OWLDifferentIndividualsAxiom>();
        for (int i = 0; i < individuals.size() - 1; ++i) {
            for (int j = i + 1; j < individuals.size(); ++j) {
                OWLIndividual indI = individuals.get(i);
                OWLIndividual indJ = individuals.get(j);
                result.add(this.getOWLDataFactory().getOWLDifferentIndividualsAxiom(indI, indJ));
            }
        }
        return result;
    }

    @Override
    public boolean containsAnonymousIndividuals() {
        for (OWLIndividual ind : this.getIndividuals()) {
            if (!ind.isAnonymous()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLDifferentIndividualsAxiom;
    }

    @Override
    public Set<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
        ArrayList<OWLObjectOneOf> nominalsList = new ArrayList<OWLObjectOneOf>();
        for (OWLIndividual individual : this.getIndividuals()) {
            nominalsList.add(this.getOWLDataFactory().getOWLObjectOneOf(individual));
        }
        HashSet<OWLSubClassOfAxiom> result = new HashSet<OWLSubClassOfAxiom>();
        for (int i = 0; i < nominalsList.size() - 1; ++i) {
            for (int j = i + 1; j < nominalsList.size(); ++j) {
                OWLClassExpression ceI = (OWLClassExpression)nominalsList.get(i);
                OWLClassExpression ceJ = ((OWLClassExpression)nominalsList.get(j)).getObjectComplementOf();
                result.add(this.getOWLDataFactory().getOWLSubClassOfAxiom(ceI, ceJ));
            }
        }
        return result;
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.DIFFERENT_INDIVIDUALS;
    }
}

