/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Set;
import org.coode.owlapi.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TypeAllDisjointClassesHandler
extends BuiltInTypeHandler {
    public TypeAllDisjointClassesHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getIRI());
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        this.consumeTriple(subject, predicate, object);
        IRI listNode = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), true);
        if (listNode != null) {
            Set<OWLClassExpression> desc = this.getConsumer().translateToClassExpressionSet(listNode);
            Set<OWLAnnotation> annotations = this.getConsumer().translateAnnotations(subject);
            this.getConsumer().setPendingAnnotations(annotations);
            this.addAxiom(this.getDataFactory().getOWLDisjointClassesAxiom(desc, this.getPendingAnnotations()));
        }
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }
}

