/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoerceConstantsIntoDataPropertyRange
extends AbstractCompositeOntologyChange {
    private Map<OWLDataPropertyExpression, OWLDatatype> map;
    private List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();

    public CoerceConstantsIntoDataPropertyRange(OWLDataFactory dataFactory, Set<OWLOntology> ontologies) {
        super(dataFactory);
        this.map = new HashMap<OWLDataPropertyExpression, OWLDatatype>();
        for (OWLOntology ont : ontologies) {
            for (OWLDataPropertyRangeAxiom ax : ont.getAxioms(AxiomType.DATA_PROPERTY_RANGE)) {
                if (!((OWLDataRange)ax.getRange()).isDatatype()) continue;
                this.map.put((OWLDataPropertyExpression)ax.getProperty(), (OWLDatatype)ax.getRange());
            }
        }
        OWLConstantReplacer replacer = new OWLConstantReplacer(this.getDataFactory());
        for (OWLOntology ont : ontologies) {
            for (OWLLogicalAxiom ax : ont.getLogicalAxioms()) {
                OWLAxiom dupAx;
                if (ax.equals(dupAx = (OWLAxiom)replacer.duplicateObject(ax))) continue;
                this.changes.add(new RemoveAxiom(ont, ax));
                this.changes.add(new AddAxiom(ont, dupAx));
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }

    private class OWLConstantReplacer
    extends OWLObjectDuplicator {
        public OWLConstantReplacer(OWLDataFactory dataFactory) {
            super(dataFactory);
        }

        private OWLDataOneOf process(OWLDataPropertyExpression prop, OWLDataOneOf oneOf) {
            HashSet<OWLLiteral> vals = new HashSet<OWLLiteral>();
            for (OWLLiteral con : oneOf.getValues()) {
                vals.add(this.process(prop, con));
            }
            return CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataOneOf(vals);
        }

        private OWLLiteral process(OWLDataPropertyExpression prop, OWLLiteral con) {
            OWLDatatype dt = (OWLDatatype)CoerceConstantsIntoDataPropertyRange.this.map.get(prop);
            if (dt != null) {
                return CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLTypedLiteral(con.getLiteral(), dt);
            }
            return con;
        }

        public void visit(OWLDataHasValue desc) {
            super.visit(desc);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataHasValue((OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLLiteral)desc.getValue())));
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataSomeValuesFrom((OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        public void visit(OWLDataMinCardinality desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataMinCardinality(desc.getCardinality(), (OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        public void visit(OWLDataMaxCardinality desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataMaxCardinality(desc.getCardinality(), (OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        public void visit(OWLDataExactCardinality desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataExactCardinality(desc.getCardinality(), (OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        public void visit(OWLDataAllValuesFrom desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataAllValuesFrom((OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            super.visit(axiom);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getSubject(), this.process((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject())));
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            super.visit(axiom);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getSubject(), this.process((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject())));
        }
    }
}

