/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.ClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.ComplementOfTranslator;
import org.coode.owlapi.rdfxml.parser.DataAllValuesFromTranslator;
import org.coode.owlapi.rdfxml.parser.DataCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataHasValueTranslator;
import org.coode.owlapi.rdfxml.parser.DataMaxCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataMinCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataSomeValuesFromTranslator;
import org.coode.owlapi.rdfxml.parser.IntersectionOfTranslator;
import org.coode.owlapi.rdfxml.parser.NamedClassTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.ObjectAllValuesFromTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectHasValueTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectMaxCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectMinCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectSomeValuesFromTranslator;
import org.coode.owlapi.rdfxml.parser.OneOfTranslator;
import org.coode.owlapi.rdfxml.parser.SelfRestrictionTranslator;
import org.coode.owlapi.rdfxml.parser.UnionOfTranslator;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class ClassExpressionTranslatorSelector {
    private OWLRDFConsumer consumer;
    private IntersectionOfTranslator intersectionOfTranslator;
    private UnionOfTranslator unionOfTranslator;
    private ComplementOfTranslator complementOfTranslator;
    private OneOfTranslator oneOfTranslator;
    private SelfRestrictionTranslator selfRestrictionTranslator;
    private ObjectAllValuesFromTranslator objectAllValuesFromTranslator;
    private ObjectSomeValuesFromTranslator objectSomeValuesFromTranslator;
    private ObjectHasValueTranslator objectHasValueTranslator;
    private ObjectMinCardinalityTranslator objectMinCardinalityTranslator;
    private ObjectCardinalityTranslator objectCardinalityTranslator;
    private ObjectMaxCardinalityTranslator objectMaxCardinalityTranslator;
    private DataAllValuesFromTranslator dataAllValuesFromTranslator;
    private DataSomeValuesFromTranslator dataSomeValuesFromTranslator;
    private DataHasValueTranslator dataHasValueTranslator;
    private DataMinCardinalityTranslator dataMinCardinalityTranslator;
    private DataCardinalityTranslator dataCardinalityTranslator;
    private DataMaxCardinalityTranslator dataMaxCardinalityTranslator;
    private NamedClassTranslator namedClassTranslator;

    public ClassExpressionTranslatorSelector(OWLRDFConsumer con) {
        this.consumer = con;
        this.intersectionOfTranslator = new IntersectionOfTranslator(con);
        this.unionOfTranslator = new UnionOfTranslator(con);
        this.complementOfTranslator = new ComplementOfTranslator(con);
        this.oneOfTranslator = new OneOfTranslator(con);
        this.selfRestrictionTranslator = new SelfRestrictionTranslator(con);
        this.objectAllValuesFromTranslator = new ObjectAllValuesFromTranslator(con);
        this.objectSomeValuesFromTranslator = new ObjectSomeValuesFromTranslator(con);
        this.objectHasValueTranslator = new ObjectHasValueTranslator(con);
        this.objectMinCardinalityTranslator = new ObjectMinCardinalityTranslator(con);
        this.objectCardinalityTranslator = new ObjectCardinalityTranslator(con);
        this.objectMaxCardinalityTranslator = new ObjectMaxCardinalityTranslator(con);
        this.dataAllValuesFromTranslator = new DataAllValuesFromTranslator(con);
        this.dataSomeValuesFromTranslator = new DataSomeValuesFromTranslator(con);
        this.dataHasValueTranslator = new DataHasValueTranslator(con);
        this.dataMinCardinalityTranslator = new DataMinCardinalityTranslator(con);
        this.dataCardinalityTranslator = new DataCardinalityTranslator(con);
        this.dataMaxCardinalityTranslator = new DataMaxCardinalityTranslator(con);
        this.namedClassTranslator = new NamedClassTranslator(con);
    }

    public boolean isObjectRestriction(IRI mainNode, IRI property) {
        if (this.consumer.isObjectPropertyOnly(property)) {
            return true;
        }
        if (this.isClassExpressionObject(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI())) {
            return true;
        }
        if (this.isClassExpressionObject(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI())) {
            return true;
        }
        if (this.isClassExpressionObject(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY.getIRI())) {
            return true;
        }
        if (this.isClassExpressionObject(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY.getIRI())) {
            return true;
        }
        if (this.isClassExpressionObject(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY.getIRI())) {
            return true;
        }
        return this.consumer.getResourceObject(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), false) != null;
    }

    private boolean isClassExpressionObject(IRI mainNode, IRI predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.consumer.isClass(object);
    }

    public boolean isDataRestriction(IRI mainNode, IRI property) {
        if (this.consumer.isDataPropertyOnly(property)) {
            return true;
        }
        if (this.isDataRangeObject(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI())) {
            return true;
        }
        if (this.isDataRangeObject(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI())) {
            return true;
        }
        if (this.isDataRangeObject(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY.getIRI())) {
            return true;
        }
        if (this.isDataRangeObject(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY.getIRI())) {
            return true;
        }
        if (this.isDataRangeObject(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY.getIRI())) {
            return true;
        }
        return this.consumer.getLiteralObject(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), false) != null;
    }

    private boolean isDataRangeObject(IRI mainNode, IRI predicate) {
        IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
        return object != null && this.consumer.isDataRange(object);
    }

    public ClassExpressionTranslator getClassExpressionTranslator(IRI mainNode) {
        if (this.consumer.isRestriction(mainNode)) {
            IRI onPropertyIRI = this.consumer.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), false);
            if (onPropertyIRI == null) {
                return this.namedClassTranslator;
            }
            if (this.isObjectRestriction(mainNode, onPropertyIRI)) {
                return this.getObjectRestrictionTranslator(mainNode);
            }
            if (this.isDataRestriction(mainNode, onPropertyIRI)) {
                return this.getDataRestrictionTranslator(mainNode);
            }
            return this.namedClassTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI())) {
            return this.intersectionOfTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_UNION_OF.getIRI())) {
            return this.unionOfTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI())) {
            return this.complementOfTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_ONE_OF.getIRI())) {
            return this.oneOfTranslator;
        }
        return this.namedClassTranslator;
    }

    private ClassExpressionTranslator getObjectRestrictionTranslator(IRI mainNode) {
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI())) {
            return this.objectSomeValuesFromTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI())) {
            return this.objectAllValuesFromTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI())) {
            return this.objectHasValueTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI()) || this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY.getIRI())) {
            return this.objectMinCardinalityTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_CARDINALITY.getIRI()) || this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY.getIRI())) {
            return this.objectCardinalityTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI()) || this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY.getIRI())) {
            return this.objectMaxCardinalityTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_HAS_SELF.getIRI())) {
            return this.selfRestrictionTranslator;
        }
        return this.namedClassTranslator;
    }

    private ClassExpressionTranslator getDataRestrictionTranslator(IRI mainNode) {
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI())) {
            return this.dataSomeValuesFromTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI())) {
            return this.dataAllValuesFromTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI())) {
            return this.dataHasValueTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI()) || this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY.getIRI())) {
            return this.dataMinCardinalityTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_CARDINALITY.getIRI()) || this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY.getIRI())) {
            return this.dataCardinalityTranslator;
        }
        if (this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI()) || this.consumer.hasPredicate(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY.getIRI())) {
            return this.dataMaxCardinalityTranslator;
        }
        return this.namedClassTranslator;
    }
}

