/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExtensionNamespaceSupport;
import org.apache.xalan.templates.ElemParam;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElemExsltFunction
extends ElemTemplate {
    private boolean m_isResultSet = false;
    private XObject m_result;
    private int m_callerFrameSize = 0;

    public int getXSLToken() {
        return 88;
    }

    public String getNodeName() {
        return "function";
    }

    public void execute(TransformerImpl transformer, XObject[] args) throws TransformerException {
        this.m_isResultSet = false;
        this.m_result = null;
        XPathContext xctxt = transformer.getXPathContext();
        VariableStack vars = xctxt.getVarStack();
        int oldStackFrame = vars.getStackFrame();
        vars.setStackFrame(this.m_callerFrameSize + oldStackFrame);
        NodeList children = this.getChildNodes();
        int numparams = 0;
        int i = 0;
        while (i < args.length) {
            Node child = children.item(i);
            if (children.item(i) instanceof ElemParam) {
                ++numparams;
                ElemParam param = (ElemParam)children.item(i);
                vars.setLocalVariable(param.getIndex(), args[i]);
            }
            ++i;
        }
        if (numparams < args.length) {
            throw new TransformerException("function called with too many args");
        }
        if (TransformerImpl.S_DEBUG) {
            transformer.getTraceManager().fireTraceEvent(this);
        }
        transformer.executeChildTemplates((ElemTemplateElement)this, true);
        vars.setStackFrame(oldStackFrame);
        this.m_callerFrameSize = 0;
        if (TransformerImpl.S_DEBUG) {
            transformer.getTraceManager().fireTraceEndEvent(this);
        }
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        String namespace = this.getName().getNamespace();
        String handlerClass = "org.apache.xalan.extensions.ExtensionHandlerExsltFunction";
        Object[] args = new Object[]{namespace, sroot};
        ExtensionNamespaceSupport extNsSpt = new ExtensionNamespaceSupport(namespace, handlerClass, args);
        sroot.getExtensionNamespacesManager().registerExtension(extNsSpt);
        if (!namespace.equals("http://exslt.org/functions")) {
            namespace = "http://exslt.org/functions";
            args = new Object[]{namespace, sroot};
            extNsSpt = new ExtensionNamespaceSupport(namespace, handlerClass, args);
            sroot.getExtensionNamespacesManager().registerExtension(extNsSpt);
        }
    }

    public XObject getResult() {
        return this.m_result;
    }

    public void setResult(XObject result) {
        this.m_isResultSet = true;
        this.m_result = result;
    }

    public boolean isResultSet() {
        return this.m_isResultSet;
    }

    public void clearResult() {
        this.m_isResultSet = false;
        this.m_result = null;
    }

    public void setCallerFrameSize(int callerFrameSize) {
        this.m_callerFrameSize = callerFrameSize;
    }
}

