die qq(
Bad numbr of inputs

) if(!@ARGV);

my $input=$ARGV[0];
my $vcf=$ARGV[1];


# Convert output to VCF format
open(FH, $input) or die "Couldn't open jsm file $input!\n";
open(OUT, ">$vcf") or die "Couldn't create vcf file $vcf!\n";

# print the vcf format we are using
print OUT "##fileformat=VCFv4.1\n";

# grab header which is the first line after the comment lines which start with ##
my $header = <FH>;
while(grep(/^##/, $header)) 
{
	$header = <FH>;
}
my @head = split("\t", $header);

print "Converting jsm output to vcf\n";
# vcf header is
# #CHROM POS ID REF ALT QUAL FILTER INFO
print OUT "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\n";
# for each line in jsm transform to vcf, any columns not in vcf concatenate them
# together and place them in the info column
while (my $line = <FH>) 
{
	chomp $line;
	my @fields = split("\t", $line);
	# create info column
	# tumor_name=MH208_TUMOR;normal_name=MH208_LIVER;...;n_alt_sum=702
	my @info;
	for(my $index = 4; $index < $#fields; $index++) 
	{
		push @info, "$head[$index]=$fields[$index]";
	} 
	my $infofield = join(";", @info);
	$fields[-1] = "PASS";
	
	# print the line
	print OUT "$fields[0]\t$fields[1]\t.\t$fields[2]\t$fields[3]\t.\t$fields[-1]\t$infofield\n";
}
close(FH);
close(OUT);
