#!/bin/bash
#
# Galaxy wrapper for Bismark
#

set -e


#get parameters

until [ $# -eq 0 ]
do
	case $1 in
		ref=*)
			ref=${1#ref=}
			;;
		library=*)
			library=${1#library=}
			;;
		fullparam=*)
			fullparam=${1#fullparam=}
			;;
		mate1=*)
			mate1=${1#mate1=}
			;;
		mate2=*)
			mate2=${1#mate2=}
			;;
		qual=*)
			qual=${1#qual=}
			;;
		seedmms=*)
			seedmms="--seedmms ${1#seedmms=}"
			;;
		seedlen=*)
			seedlen="--seedlen ${1#seedlen=}"
			;;
		maqerr=*)
			maqerr="--maqerr ${1#maqerr=}"
			;;
		directional=*)
			directional=${1#directional=}
			;;
		header=*)
			header=${1#header=}
			;;
		minins=*)
			minins="--minins ${1#minins=}"
			;;
		maxins=*)
			maxins="--maxins ${1#maxins=}"
			;;
		mapped=*)
			mapped=${1#mapped=}
			;;
		summary=*)
			summary=${1#summary=}
			;;
		tempdir=*)
			tempdir=${1#tempdir=}
			;;
	esac
	shift
done


if [ "$library" == "single" ]
then
    if [ "$fullparam" == 'false' ]
    then      
      bismark --output_dir $tempdir --temp_dir $tempdir --quiet $ref $mate1  2>&1 > /dev/null
    else
      bismark --output_dir $tempdir --temp_dir $tempdir --quiet $qual $seedmms $seedlen $maqerr $directional $header $ref $mate1  2>&1 > /dev/null
    fi
else
    if [ "$fullparam" == 'false' ]
    then
      bismark --output_dir $tempdir --temp_dir $tempdir --quiet $ref -1 $mate1 -2 $mate2 2>&1 > /dev/null
    else
      bismark --output_dir $tempdir --temp_dir $tempdir --quiet $qual $seedmms $seedlen $maqerr $directional $header $minins $maxins $ref -1 $mate1 -2 $mate2 2>&1 > /dev/null
    fi
fi


#call bismark. output in temp-directory (files_path)


#parse the filename of the input -> same as output
IFS="/"
set - $mate1
outfile=${*:$#:1}

#sort the mapped reads by chromosome
#sort -k 3,3 -k 4,4n "$tempdir/${outfile}_bismark_pe.sam" > "$tempdir/${outfile}_bismark_pe_sorted.sam"

#copy resultfiles back into galaxy
#cp "$tempdir/${outfile}_bismark_sorted.sam" "$mapped"
if [ "$library" == "single" ]
then
    cp "$tempdir/${outfile}_bismark.sam" "$mapped"
    cp "$tempdir/${outfile}_Bismark_mapping_report.txt" "$summary"
else
    cp "$tempdir/${outfile}_bismark_pe.sam" "$mapped"
    cp "$tempdir/${outfile}_Bismark_paired-end_mapping_report.txt" "$summary"
fi







