#!/bin/bash
#
# Galaxy wrapper for Bismark Methylation Caller
#

set -e

#get parameters

until [ $# -eq 0 ]
do
	case $1 in
		input=*)
			input=${1#input=}
			;;
		method=*)
			method=${1#method=}
			;;
		output=*)
			output=${1#output=}
			;;
		tempdir=*)
			tempdir=${1#tempdir=}
			;;
	esac
	shift
done
(grep ^@ $input; grep -v ^@ $input | sort -k3,3 -k1,1) > $tempdir"bismark_sam_sorted.sam"
methylation_extractor -$method -o $output $tempdir"bismark_sam_sorted.sam" 2>&1 > /dev/null






