#!/usr/bin/env

## Generate genus & species summary from ganon output
## author: errol strain, estrain@gmail.com

from argparse import (ArgumentParser, FileType)
import sys
import glob 
from decimal import Decimal

def parse_args():
  "Parse the input arguments, use '-h' for help."

  parser = ArgumentParser(description='Generate summary from ganon *.tre file')

  # Read inputs
  parser.add_argument('-t','--tre_file', type=str, required=True, nargs=1, help='ganon *.tre output file')
  parser.add_argument('-f','--filename', type=str, required=True, nargs=1, help='Galaxy fastq file name')
  parser.add_argument('-o','--output', type=str, required=True, nargs=1, help='Output filename')
  parser.add_argument('-r','--ranks', type=str, required=False, help='Taxanomic ranks',default="genus species")
  parser.add_argument('-n','--num_reports', type=str, required=False, help='Maxinum number of reports per taxonomic rank', default="2")

  return parser.parse_args()

args =parse_args()

# Open ganon *.tre file 
trefile = open(args.tre_file[0],"r")
output = open(args.output[0],"w")

rankhash = {}
for val in args.ranks.split() :
  rankhash[val]=1

els = trefile.readline().split('\t')
outline = str(args.filename[0]) + "\tTotal Reads\t"+els[4]+"\t"
els = trefile.readline().split('\t')
outline = outline + "Reads Mapped\t"+els[4]+"\t"

rindex=0
rcur =  ""
for line in trefile.readlines() :
  line = line.rstrip()
  els = line.split('\t')
  if els[0] in rankhash and rindex < int(args.num_reports) : 
    outline = outline + els[0] + ":" + els[3] + " (%)\t" + str(els[5]) + "\t"
    rindex += 1
    rcur=els[0]
  elif els[0] in rankhash and els[0] != rcur :
    outline = outline + els[0] + ":" + els[3] + " (%)\t" + str(els[5]) + "\t"
    rindex=1
    rcur=els[0]

outline.rstrip()
output.write(outline + "\n")
