#!/usr/bin/env python

import argparse
import json
import os
import os.path
import sys

def _add_data_table_entry(data_manager_dict, data_table_entry, data_table_name):
    data_manager_dict['data_tables'] = data_manager_dict.get('data_tables', {})
    data_manager_dict['data_tables'][data_table_name] = data_manager_dict['data_tables'].get('ganon_databases', [])
    data_manager_dict['data_tables'][data_table_name].append(data_table_entry)
    return data_manager_dict

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Download RefSeq rRNA bacterial databases')
    parser.add_argument('--output_directory', default='/tool-data/ganon', help='Directory to write output')
    parser.add_argument('--rrna', help='rRNA sequences to download (5S, 16S, or 23S)')
    args = parser.parse_args()

    output_directory = args.output_directory
    if not os.path.exists(output_directory):
        os.mkdir(output_directory)

    data_manager_dict = {}
    _add_data_table_entry(data_manager_dict=data_manager_dict,
      data_table_entry=dict(value="ganon"+args.rrna, dbkey="gannon"+args.rrna, name=args.rrna, path=args.output_directory),
      data_table_name='ganon_databases')
    open("output_file", 'w').write(json.dumps(data_manager_dict, sort_keys=True))

