var app = angular.module('app', ['ngTouch', 'ui.grid','ui.grid.grouping', 'ui.grid.pagination', 'ui.grid.exporter']);

app.controller('MainCtrl', ['$scope', '$http', '$interval', 'uiGridGroupingConstants', function ($scope, $http, $interval, uiGridGroupingConstants ){
  $scope.gridOptions = {
    enableFiltering: true,
    enableGridMenu: true,
    enableSelectAll: true,
    exporterCsvFilename: 'myFile.csv',
    exporterMenuPdf: false,
    treeRowHeaderAlwaysVisible: false,
    paginationPageSizes: [25, 50],
    paginationPageSize: 25,
    exporterCsvLinkElement: angular.element(document.querySelectorAll(".custom-csv-link-location")),
    //enableHorizontalScrollbar: 0,
    //enableVerticalScrollbar: 1,
    columnDefs: [
      { name: 'contig', grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'desc' }, width: '25%', cellTemplate: '<div><div ng-if="!col.grouping || col.grouping.groupPriority === undefined || col.grouping.groupPriority === null || ( row.groupHeader && col.grouping.groupPriority === row.treeLevel )" class="ui-grid-cell-contents" title="TOOLTIP">{{COL_FIELD CUSTOM_FILTERS}}</div></div>' },
      { name: 'mRNA', grouping: { groupPriority: 1 }, sort: { priority: 1,direction: 'desc' }, width: '25%', cellTemplate: '<div><div ng-if="!col.grouping || col.grouping.groupPriority === undefined || col.grouping.groupPriority === null || ( row.groupHeader && col.grouping.groupPriority === row.treeLevel )" class="ui-grid-cell-contents" title="TOOLTIP">{{COL_FIELD CUSTOM_FILTERS}}</div></div>' },
      { name: 'prediction', width: '25%' },
      { name: 'source', width: '10%' },
      { name: 'score', width: '5%'},
    ],
    onRegisterApi: function( gridApi ) {
      $scope.gridApi = gridApi;
    }
  };

    var  baseurl= '/api/datasets/'+hdaId+'?provider=sqlite-dict&data_type=raw_data&query=';
    var  select="select%20transcript_id%20as%20contig,%20query_prot_id%20as%20mRNA,'SignalPeptide'%20as%20prediction,%20'signalp'%20as%20source,%20score%20from%20signalp%20s,%20orf%20o%20where%20s.query_prot_id=o.orf_id%20union%20\
      select%20transcript_id%20as%20contig,%20orf_id%20as%20mRNA,peptide%20as%20prediction,%20'transdecoder'%20as%20source,%20length%20as%20score%20from%20orf%20union%20\
      select%20transcript_id%20as%20contig,%20queryprotid%20as%20mRNA,%20substr(Topology,10)%20as%20prediction,%20'tmhmmer'%20as%20source%20,substr(Score,7)%20as%20score%20from%20tmhmm%20t,%20orf%20o%20where%20t.queryprotid=o.orf_id%20and%20PredHel%20<>%20'PredHel=0'%20union%20\
      select%20transcript_id%20as%20contig,%20TrinityID%20as%20mRNA,%20substr(LinkId,15)%20as%20prediction%20,%20DatabaseSource%20as%20source,%20BitScore%20as%20score\
      from%20blastdbase%20b%20,%20%20uniprotindex%20u,%20orf%20o%20where%20b.Trinityid=o.orf_id%20and%20u.Accession=b.FullAccession%20and%20u.AttributeType%20='D'%20union%20\
      select%20transcript_id%20as%20contig,%20QueryProtID%20as%20mRNA,%20HMMERTDomainDescription%20as%20prediction,%20'hmmer'%20as%20source,%20ThisDomainEvalue%20as%20score%20%20from%20hmmerdbase%20h,pfamreference%20p,orf%20o%20where%20h.queryprotid=o.orf_id%20and%20h.FullDomainScore%20>=%20p.Domain_NoiseCutoff%20and%20p.pfam_accession=h.pfam_id";
    var url= baseurl + select;
    $http.get(url)
     .success (function(response){
         $scope.gridOptions.data = [].concat.apply([], response.data);
        //mygridOptions.totalItems = mygridOptions.data.length;
     });//end get_url
}])
