/*
 * Decompiled with CFR 0.152.
 */
package jspp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import jspp.SequenceLengthException;

public class SearchMatrix
implements Serializable {
    private int[][] matrix;
    private double[][] logprobmatrix;
    private double[][] probmatrix;
    private double[] information;
    private int xdim;
    private int ydim;
    private int[] aafrequency;
    private int aacount = 0;
    private double cutoff = -1.0;
    private double uppercut = -1.0;
    private double fn = -1.0;
    private int[] positions;
    private double rawcutoff = -1.0;
    private int cpos;

    public SearchMatrix(String[] alignedsequences, int cleavageposition) {
        this.cpos = cleavageposition;
        this.xdim = alignedsequences[0].length();
        this.ydim = 26;
        this.matrix = new int[this.xdim][this.ydim];
        this.information = new double[this.xdim];
        for (int i = 0; i < alignedsequences.length; ++i) {
            String sequence = alignedsequences[i].toUpperCase();
            for (int n = 0; n < sequence.length(); ++n) {
                char aa = sequence.charAt(n);
                int[] nArray = this.matrix[n];
                int n2 = aa - 65;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        this.updateLogProbMatrix();
    }

    public SearchMatrix(int sequencelength, int cleavageposition) {
        this.cpos = cleavageposition;
        this.xdim = sequencelength;
        this.ydim = 26;
        this.matrix = new int[this.xdim][this.ydim];
    }

    protected int getColumnSum(int column) {
        if (this.xdim == 0 || this.ydim == 0) {
            return -1;
        }
        int sum = 0;
        for (int i = 0; i < this.ydim; ++i) {
            sum += this.matrix[column][i];
        }
        return sum;
    }

    public int getSequenceLength() {
        return this.xdim;
    }

    protected int getRowSum(int row) {
        if (this.xdim == 0 || this.ydim == 0) {
            return -1;
        }
        int sum = 0;
        for (int i = 0; i < this.xdim; ++i) {
            sum += this.matrix[i][row];
        }
        return sum;
    }

    public void addSequence(String sequence) throws SequenceLengthException {
        if (sequence.length() != this.xdim) {
            throw new SequenceLengthException(new String("Length should be: " + this.xdim + "\nwas: " + sequence.length()));
        }
        sequence = sequence.toUpperCase();
        for (int i = 0; i < this.xdim; ++i) {
            char aa = sequence.charAt(i);
            int[] nArray = this.matrix[i];
            int n = aa - 65;
            nArray[n] = nArray[n] + 1;
        }
        this.updateLogProbMatrix();
    }

    public void addSearchMatrix(SearchMatrix matrix) throws SequenceLengthException {
        if (matrix.getSequenceLength() != this.xdim) {
            throw new SequenceLengthException(new String("Length should be: " + this.xdim + "\nwas: " + matrix.getSequenceLength()));
        }
        int[][] mx = matrix.getMatrix();
        for (int i = 0; i < mx[0].length; ++i) {
            for (int n = 0; n < mx.length; ++n) {
                int[] nArray = this.matrix[n];
                int n2 = i;
                nArray[n2] = nArray[n2] + mx[n][i];
            }
        }
        this.updateLogProbMatrix();
    }

    public void removeSequence(String sequence) throws SequenceLengthException {
        if (sequence.length() != this.xdim) {
            throw new SequenceLengthException(new String("Length should be: " + this.xdim + "\nwas: " + sequence.length()));
        }
        sequence = sequence.toUpperCase();
        for (int i = 0; i < this.xdim; ++i) {
            char aa = sequence.charAt(i);
            int[] nArray = this.matrix[i];
            int n = aa - 65;
            nArray[n] = nArray[n] - 1;
        }
        this.updateLogProbMatrix();
    }

    private void updateProbMatrix() {
        this.probmatrix = new double[this.xdim][this.ydim];
        for (int i = 0; i < this.xdim; ++i) {
            for (int n = 0; n < this.ydim; ++n) {
                this.probmatrix[i][n] = this.aafrequency == null ? Math.log((double)this.matrix[i][n] / (double)this.getColumnSum(i)) : Math.log((double)this.matrix[i][n] * (0.05 / ((double)this.aafrequency[n] / (double)this.aacount)) / (double)this.getColumnSum(i));
                if (!Double.isNaN(this.probmatrix[i][n])) continue;
                this.probmatrix[i][n] = 0.0;
            }
        }
    }

    private void updateLogProbMatrix() {
        this.logprobmatrix = new double[this.xdim][this.ydim];
        for (int i = 0; i < this.xdim; ++i) {
            for (int n = 0; n < this.ydim; ++n) {
                this.logprobmatrix[i][n] = this.aafrequency == null ? Math.log((double)this.matrix[i][n] / (double)this.getColumnSum(i)) : Math.log((double)this.matrix[i][n] * (0.05 / ((double)this.aafrequency[n] / (double)this.aacount)) / (double)this.getColumnSum(i));
                if (!Double.isNaN(this.logprobmatrix[i][n]) && !Double.isInfinite(this.logprobmatrix[i][n])) continue;
                this.logprobmatrix[i][n] = Math.log(1 / (this.getColumnSum(i) + 1));
            }
        }
    }

    public int getCleavagePosition() {
        return this.cpos;
    }

    public void setLimits(double cutoff, double uppercutoff) {
        this.rawcutoff = cutoff;
        this.cutoff = cutoff;
        this.uppercut = uppercutoff;
        this.fn = 0.5 / (this.uppercut - this.cutoff);
    }

    public double getScore(String sequence) throws SequenceLengthException {
        if (this.uppercut == -1.0 || this.cutoff == -1.0) {
            return this.getRawScore(sequence);
        }
        return (this.getRawScore(sequence) - this.cutoff) * this.fn + this.cutoff;
    }

    public double getRawScore(String sequence) throws SequenceLengthException {
        if (sequence.length() != this.xdim) {
            throw new SequenceLengthException(new String("Length should be: " + this.xdim + "\nwas: " + sequence.length()));
        }
        sequence = sequence.toUpperCase();
        double score = this.logprobmatrix[0][sequence.charAt(0) - 65];
        for (int i = 1; i < sequence.length(); ++i) {
            score += this.logprobmatrix[i][sequence.charAt(i) - 65];
        }
        return score;
    }

    public double getCutOffScore() {
        return this.rawcutoff;
    }

    public double raw2normalizedScore(double rawscore) {
        double score = rawscore * this.fn + (1.0 - 0.5 * this.uppercut / (this.uppercut - this.cutoff));
        if (score < 0.0) {
            score = 0.0;
        } else if (score > 1.0) {
            score = 1.0;
        }
        return score;
    }

    public double getInformation(int position) throws SequenceLengthException {
        if (position >= this.xdim) {
            throw new SequenceLengthException(new String("Position should be maximal: " + this.xdim + "\nwas: " + position));
        }
        this.updateProbMatrix();
        double information = 0.0;
        for (int i = 0; i < this.ydim; ++i) {
            information += this.probmatrix[position][i] * (Double.isInfinite(Math.log(this.probmatrix[position][i])) ? 0.0 : Math.log(this.probmatrix[position][i])) / Math.log(2.0);
        }
        return 4.700439718141092 - (information *= -1.0);
    }

    public int[][] getMatrix() {
        return (int[][])this.matrix.clone();
    }

    public void setFrequencyMatrix(String[] sequences) {
        this.aafrequency = new int[this.ydim];
        this.aacount = 0;
        for (int i = 0; i < sequences.length; ++i) {
            for (int n = 0; n < sequences[i].length(); ++n) {
                char aa = sequences[i].charAt(n);
                int n2 = aa - 65;
                this.aafrequency[n2] = this.aafrequency[n2] + 1;
                ++this.aacount;
            }
        }
        this.updateLogProbMatrix();
    }

    public void setFrequencyMatrix(SearchMatrix sequences) {
        this.aafrequency = new int[this.ydim];
        this.aacount = 0;
        for (int i = 0; i < this.ydim; ++i) {
            int n = i;
            this.aafrequency[n] = this.aafrequency[n] + sequences.getRowSum(i);
            this.aacount += sequences.getRowSum(i);
        }
        this.updateLogProbMatrix();
    }

    public void writeMatrix(File file) throws IOException {
        int i;
        FileWriter out = new FileWriter(file);
        out.write("\t");
        for (i = 0; i < this.xdim; ++i) {
            out.write(i + "\t");
        }
        out.write("\n");
        for (i = 0; i < this.ydim; ++i) {
            out.write((char)(65 + i) + "\t");
            for (int n = 0; n < this.xdim; ++n) {
                out.write(this.matrix[n][i] + "\t");
            }
            out.write("\n");
        }
        out.write("\t");
        for (i = 0; i < this.xdim; ++i) {
            out.write(String.valueOf(this.getInformation(i)) + "\t");
        }
        out.write("\n");
        out.close();
    }
}

