/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import jspp.SearchMatrix;
import jspp.SignalPeptidePredictor;

public class JSPP {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("USAGE: JSPP positive-matrix.smx sequences.fasta result.txt");
            System.exit(0);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = new File(stringArray[2]);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            SearchMatrix searchMatrix = (SearchMatrix)objectInputStream.readObject();
            objectInputStream.close();
            SignalPeptidePredictor signalPeptidePredictor = new SignalPeptidePredictor(searchMatrix);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
            bufferedWriter.write("##gff-version 2\n");
            bufferedWriter.write("##sequence-name source  feature start   end     score   N/A ?\n");
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(">") == -1) continue;
                String string2 = string.substring(string.indexOf(">") + 1);
                String string3 = bufferedReader.readLine();
                if (string3 == null) {
                    System.err.println("Error reading FASTA-File !");
                    System.exit(0);
                }
                int n = signalPeptidePredictor.predictEnhancedPosition(string3);
                double d = signalPeptidePredictor.getScore();
                if (!signalPeptidePredictor.isSignalPeptide()) continue;
                bufferedWriter.write(string2 + "\tPredSi\tSIGNAL\t1\t" + n + "\t" + d + "\t.\t.\tYES\n");
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("IO-Error: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error reading matrices (wrong file ?)" + classNotFoundException);
        }
    }
}

