/*
 * Decompiled with CFR 0.152.
 */
package jspp;

import jspp.SearchMatrix;

public class SignalPeptidePredictor {
    private SearchMatrix positive;
    private SearchMatrix negative;
    private int window;
    private int clpos;
    private double score = -1.0;

    public SignalPeptidePredictor(String[] positive, String[] negative, int clpos) {
        this.positive = new SearchMatrix(positive, clpos);
        this.positive.setFrequencyMatrix(negative);
        this.negative = new SearchMatrix(negative, clpos);
        this.window = positive[0].length();
        this.clpos = clpos;
    }

    protected SignalPeptidePredictor() {
    }

    public SignalPeptidePredictor(SearchMatrix positive) {
        this.positive = positive;
        this.window = positive.getSequenceLength();
        this.clpos = positive.getCleavagePosition() + 1;
    }

    protected void setMatrix(SearchMatrix sm) {
        this.positive = sm;
        this.window = this.positive.getSequenceLength();
        this.clpos = this.positive.getCleavagePosition() + 1;
    }

    public int predictEnhancedPosition(String sequence) {
        double bestscore = -100.0;
        int position = 0;
        for (int i = 0; i < sequence.length() - (this.window + 1); ++i) {
            String wsequence = sequence.substring(i, i + this.window);
            double score = this.positive.getRawScore(wsequence);
            if (!(score > bestscore)) continue;
            bestscore = score;
            position = i + this.clpos;
        }
        this.score = bestscore;
        return position;
    }

    public int predictPosition(String sequence) {
        double bestscore = -100.0;
        int position = 0;
        for (int i = 0; i < sequence.length() - (this.window + 1); ++i) {
            String wsequence = sequence.substring(i, i + this.window);
            double scorep = this.positive.getScore(wsequence);
            double score = scorep;
            if (!(score > bestscore)) continue;
            bestscore = score;
            position = i + this.clpos;
        }
        this.score = bestscore;
        return position;
    }

    public double getRawScore() {
        return this.score;
    }

    public double getScore() {
        return this.positive.raw2normalizedScore(this.score);
    }

    public boolean isSignalPeptide() {
        return this.positive.raw2normalizedScore(this.score) > 0.5;
    }

    public static void main(String[] args) {
    }
}

